/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.export;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelGeneratorKt$isAllowedFakeOverriddenDeclaration$;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedAttribute;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedDeclaration;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedVisibility;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0013\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0014\u001a\u00020\u0003*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0015\u001a\u00020\u0003*\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0018\u001a!\u0010\u001f\u001a\u0002H \"\b\b\u0000\u0010 *\u00020!*\u0002H 2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\"\u001a\n\u0010#\u001a\u00020\u0001*\u00020$\u001a\n\u0010%\u001a\u00020\u0001*\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0018\u0010\u0006\u001a\u00020\u0003*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\b\"\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"magicPropertyName", "", "isInterface", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Z", "isStaticMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getExportCandidate", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldDeclarationBeExportedImplicitlyOrExplicitly", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "shouldDeclarationBeExported", "isAllowedFakeOverriddenDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrOverridableDeclaration;", "isOverriddenExported", "isExported", "isExportedImplicitlyOrExplicitly", "toExportedVisibility", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedVisibility;", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "reservedWords", "", "strictModeReservedWords", "getStrictModeReservedWords", "()Ljava/util/Set;", "allReservedWords", "withAttributesFor", "T", "Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "(Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;)Lorg/jetbrains/kotlin/ir/backend/js/export/ExportedDeclaration;", "getExportedIdentifierForClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getExportedIdentifier", "backend.js"})
@SourceDebugExtension(value={"SMAP\nExportModelGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/export/ExportModelGeneratorKt\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,902:1\n226#2:903\n477#3:904\n1251#3,2:905\n1755#4,3:907\n1#5:910\n*S KotlinDebug\n*F\n+ 1 ExportModelGenerator.kt\norg/jetbrains/kotlin/ir/backend/js/export/ExportModelGeneratorKt\n*L\n790#1:903\n801#1:904\n805#1:905,2\n810#1:907,3\n*E\n"})
public final class ExportModelGeneratorKt {
    @NotNull
    private static final Set<String> reservedWords;
    @NotNull
    private static final Set<String> strictModeReservedWords;
    @NotNull
    private static final Set<String> allReservedWords;

    private static final boolean isInterface(IrClassifierSymbol $this$isInterface) {
        IrSymbolOwner irSymbolOwner = $this$isInterface.getOwner();
        IrClass irClass = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
        return irClass != null ? IrUtilsKt.isInterface(irClass) : false;
    }

    private static final boolean isStaticMethod(IrFunction $this$isStaticMethod) {
        return ES6ConstructorLoweringKt.isEs6ConstructorReplacement($this$isStaticMethod) || IrDeclarationsKt.isStaticMethodOfClass($this$isStaticMethod);
    }

    private static final IrDeclarationWithName getExportCandidate(IrDeclaration declaration) {
        if (!(declaration instanceof IrDeclarationWithVisibility) || !(declaration instanceof IrDeclarationWithName) || !((IrDeclarationWithVisibility)declaration).getVisibility().isPublicAPI() || IrUtilsKt.isExpect(declaration)) {
            return null;
        }
        if (declaration instanceof IrSimpleFunction) {
            IrProperty property;
            IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)declaration).getCorrespondingPropertySymbol();
            IrProperty irProperty = property = irPropertySymbol != null ? (IrProperty)irPropertySymbol.getOwner() : null;
            if (property != null) {
                return Intrinsics.areEqual(property.getGetter(), declaration) ? (IrDeclarationWithName)property : null;
            }
        }
        return (IrDeclarationWithName)declaration;
    }

    private static final boolean shouldDeclarationBeExportedImplicitlyOrExplicitly(IrDeclarationWithName declaration, JsIrBackendContext context2) {
        return AnnotationUtilsKt.isJsImplicitExport(declaration) || ExportModelGeneratorKt.shouldDeclarationBeExported(declaration, context2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldDeclarationBeExported(IrDeclarationWithName declaration, JsIrBackendContext context2) {
        boolean bl;
        if (declaration instanceof IrClass && ((IrClass)declaration).getKind() == ClassKind.ENUM_ENTRY) {
            return false;
        }
        if (AnnotationUtilsKt.isJsExportIgnore(declaration)) {
            return false;
        }
        if (CollectionsKt.contains((Iterable)context2.getAdditionalExportedDeclarationNames(), IrUtilsKt.getFqNameWhenAvailable(declaration))) {
            return true;
        }
        if (context2.getAdditionalExportedDeclarations().contains(declaration)) {
            return true;
        }
        if (declaration instanceof IrOverridableDeclaration) {
            boolean overriddenNonEmpty;
            boolean bl2 = overriddenNonEmpty = !((Collection)((IrOverridableDeclaration)declaration).getOverriddenSymbols()).isEmpty();
            if (overriddenNonEmpty) {
                boolean bl3;
                if (ExportModelGeneratorKt.isOverriddenExported((IrOverridableDeclaration)declaration, context2)) return true;
                IrDeclarationWithName irDeclarationWithName = declaration;
                IrSimpleFunction irSimpleFunction = irDeclarationWithName instanceof IrSimpleFunction ? (IrSimpleFunction)irDeclarationWithName : null;
                if (irSimpleFunction != null) {
                    if (IrUtilsKt.isMethodOfAny(irSimpleFunction)) {
                        return true;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) return true;
                if (!ExportModelGeneratorKt.isAllowedFakeOverriddenDeclaration((IrOverridableDeclaration)declaration, context2)) return false;
                return true;
            }
        }
        if (AnnotationUtilsKt.isJsExport(declaration)) {
            return true;
        }
        IrDeclarationParent parent2 = declaration.getParent();
        if (parent2 instanceof IrDeclarationWithName) {
            bl = ExportModelGeneratorKt.shouldDeclarationBeExported((IrDeclarationWithName)((Object)parent2), context2);
            return bl;
        } else {
            if (!(parent2 instanceof IrAnnotationContainer)) return false;
            bl = AnnotationUtilsKt.isJsExport((IrAnnotationContainer)((Object)parent2));
        }
        return bl;
    }

    public static final boolean isAllowedFakeOverriddenDeclaration(@NotNull IrOverridableDeclaration<?> $this$isAllowedFakeOverriddenDeclaration, @NotNull JsIrBackendContext context2) {
        boolean bl;
        block5: {
            IrOverridableDeclaration<?> firstExportedRealOverride2;
            IrOverridableDeclaration<?> irOverridableDeclaration;
            Intrinsics.checkNotNullParameter($this$isAllowedFakeOverriddenDeclaration, "<this>");
            Intrinsics.checkNotNullParameter(context2, "context");
            boolean condition$iv = $this$isAllowedFakeOverriddenDeclaration.isFakeOverride();
            boolean $i$f$runIf = false;
            if (condition$iv) {
                boolean bl2 = false;
                irOverridableDeclaration = IrFakeOverrideUtilsKt.resolveFakeOverrideMaybeAbstract($this$isAllowedFakeOverriddenDeclaration, new Function1<?, Boolean>($this$isAllowedFakeOverriddenDeclaration, context2){
                    final /* synthetic */ IrOverridableDeclaration<?> $this_isAllowedFakeOverriddenDeclaration;
                    final /* synthetic */ JsIrBackendContext $context;
                    {
                        this.$this_isAllowedFakeOverriddenDeclaration = $receiver;
                        this.$context = $context;
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final Boolean invoke(IrOverridableDeclaration<?> it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter(it, "it");
                        if (it != this.$this_isAllowedFakeOverriddenDeclaration) {
                            IrClass irClass = IrUtilsKt.getParentClassOrNull(it);
                            boolean bl2 = irClass != null ? ExportModelGeneratorKt.isExported(irClass, this.$context) : false;
                            if (bl2) {
                                bl = false;
                                return bl;
                            }
                        }
                        bl = true;
                        return bl;
                    }
                });
            } else {
                irOverridableDeclaration = null;
            }
            IrOverridableDeclaration<?> irOverridableDeclaration2 = firstExportedRealOverride2 = irOverridableDeclaration;
            if (IrJsUtilsKt.isExportedInterface(irOverridableDeclaration2 != null ? IrUtilsKt.getParentClassOrNull(irOverridableDeclaration2) : null, context2)) {
                IrOverridableDeclaration<?> irOverridableDeclaration3 = firstExportedRealOverride2;
                if (!(irOverridableDeclaration3 != null ? AnnotationUtilsKt.isJsExportIgnore(irOverridableDeclaration3) : false)) {
                    return true;
                }
            }
            Sequence<IrSymbolOwner> $this$filterIsInstance$iv = SequencesKt.map(CollectionsKt.asSequence((Iterable)$this$isAllowedFakeOverriddenDeclaration.getOverriddenSymbols()), ExportModelGeneratorKt::isAllowedFakeOverriddenDeclaration$lambda$1);
            boolean $i$f$filterIsInstance = false;
            Sequence<IrSymbolOwner> sequence2 = SequencesKt.filter($this$filterIsInstance$iv, isAllowedFakeOverriddenDeclaration$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull(sequence2, "null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence<IrClassSymbol> $this$any$iv = SequencesKt.map(SequencesKt.mapNotNull(SequencesKt.filter(sequence2, ExportModelGeneratorKt::isAllowedFakeOverriddenDeclaration$lambda$2), ExportModelGeneratorKt::isAllowedFakeOverriddenDeclaration$lambda$3), ExportModelGeneratorKt::isAllowedFakeOverriddenDeclaration$lambda$4);
            boolean $i$f$any = false;
            Iterator<IrClassSymbol> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                IrClassSymbol element$iv;
                IrClassSymbol it = element$iv = iterator2.next();
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it, context2.getIrBuiltIns().getEnumClass())) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean isOverriddenExported(@NotNull IrOverridableDeclaration<?> $this$isOverriddenExported, @NotNull JsIrBackendContext context2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$isOverriddenExported, "<this>");
            Intrinsics.checkNotNullParameter(context2, "context");
            Iterable $this$any$iv = $this$isOverriddenExported.getOverriddenSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrSymbol it = (IrSymbol)element$iv;
                    boolean bl2 = false;
                    IrSymbolOwner irSymbolOwner = it.getOwner();
                    Intrinsics.checkNotNull(irSymbolOwner, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
                    if (!ExportModelGeneratorKt.shouldDeclarationBeExported((IrDeclarationWithName)irSymbolOwner, context2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isExported(@NotNull IrDeclaration $this$isExported, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$isExported, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.getExportCandidate($this$isExported);
        if (irDeclarationWithName == null) {
            return false;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        return ExportModelGeneratorKt.shouldDeclarationBeExported(candidate2, context2);
    }

    public static final boolean isExportedImplicitlyOrExplicitly(@NotNull IrDeclaration $this$isExportedImplicitlyOrExplicitly, @NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$isExportedImplicitlyOrExplicitly, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        IrDeclarationWithName irDeclarationWithName = ExportModelGeneratorKt.getExportCandidate($this$isExportedImplicitlyOrExplicitly);
        if (irDeclarationWithName == null) {
            return false;
        }
        IrDeclarationWithName candidate2 = irDeclarationWithName;
        return ExportModelGeneratorKt.shouldDeclarationBeExportedImplicitlyOrExplicitly(candidate2, context2);
    }

    @NotNull
    public static final ExportedVisibility toExportedVisibility(@NotNull DescriptorVisibility $this$toExportedVisibility) {
        Intrinsics.checkNotNullParameter($this$toExportedVisibility, "<this>");
        return Intrinsics.areEqual($this$toExportedVisibility, DescriptorVisibilities.PROTECTED) ? ExportedVisibility.PROTECTED : ExportedVisibility.DEFAULT;
    }

    @NotNull
    public static final Set<String> getStrictModeReservedWords() {
        return strictModeReservedWords;
    }

    @NotNull
    public static final <T extends ExportedDeclaration> T withAttributesFor(@NotNull T $this$withAttributesFor, @NotNull IrDeclaration declaration) {
        block0: {
            Intrinsics.checkNotNullParameter($this$withAttributesFor, "<this>");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            String string2 = AnnotationUtilsKt.getDeprecated(declaration);
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            $this$withAttributesFor.getAttributes().add(new ExportedAttribute.DeprecatedAttribute(it));
        }
        return $this$withAttributesFor;
    }

    @NotNull
    public static final String getExportedIdentifierForClass(@NotNull IrClass $this$getExportedIdentifierForClass) {
        Intrinsics.checkNotNullParameter($this$getExportedIdentifierForClass, "<this>");
        IrClass parentClass = IrUtilsKt.getParentClassOrNull($this$getExportedIdentifierForClass);
        return parentClass != null && $this$getExportedIdentifierForClass.isCompanion() && IrUtilsKt.isInterface(parentClass) ? ExportModelGeneratorKt.getExportedIdentifierForClass(parentClass) : ExportModelGeneratorKt.getExportedIdentifier($this$getExportedIdentifierForClass);
    }

    @NotNull
    public static final String getExportedIdentifier(@NotNull IrDeclarationWithName $this$getExportedIdentifier) {
        Intrinsics.checkNotNullParameter($this$getExportedIdentifier, "<this>");
        Name $this$getExportedIdentifier_u24lambda_u248 = AnnotationUtilsKt.getJsNameOrKotlinName($this$getExportedIdentifier);
        boolean bl = false;
        if ($this$getExportedIdentifier_u24lambda_u248.isSpecial()) {
            throw new IllegalStateException(("Cannot export special name: " + $this$getExportedIdentifier.getName().asString() + " for declaration " + IrUtilsKt.getFqNameWhenAvailable($this$getExportedIdentifier)).toString());
        }
        String string2 = $this$getExportedIdentifier_u24lambda_u248.getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string2, "with(...)");
        return string2;
    }

    private static final IrSymbolOwner isAllowedFakeOverriddenDeclaration$lambda$1(IrSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOwner();
    }

    private static final boolean isAllowedFakeOverriddenDeclaration$lambda$2(IrOverridableDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOverriddenSymbols().isEmpty();
    }

    private static final IrClass isAllowedFakeOverriddenDeclaration$lambda$3(IrOverridableDeclaration it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return IrUtilsKt.getParentClassOrNull(it);
    }

    private static final IrClassSymbol isAllowedFakeOverriddenDeclaration$lambda$4(IrClass it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getSymbol();
    }

    public static final /* synthetic */ IrDeclarationWithName access$getExportCandidate(IrDeclaration declaration) {
        return ExportModelGeneratorKt.getExportCandidate(declaration);
    }

    public static final /* synthetic */ boolean access$shouldDeclarationBeExportedImplicitlyOrExplicitly(IrDeclarationWithName declaration, JsIrBackendContext context2) {
        return ExportModelGeneratorKt.shouldDeclarationBeExportedImplicitlyOrExplicitly(declaration, context2);
    }

    public static final /* synthetic */ boolean access$isStaticMethod(IrFunction $receiver) {
        return ExportModelGeneratorKt.isStaticMethod($receiver);
    }

    public static final /* synthetic */ Set access$getAllReservedWords$p() {
        return allReservedWords;
    }

    public static final /* synthetic */ boolean access$isInterface(IrClassifierSymbol $receiver) {
        return ExportModelGeneratorKt.isInterface($receiver);
    }

    static {
        String[] stringArray = new String[]{"break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "export", "extends", "false", "finally", "for", "function", "if", "import", "in", "instanceof", "new", "null", "return", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with"};
        reservedWords = SetsKt.setOf(stringArray);
        stringArray = new String[]{"as", "implements", "interface", "let", "package", "private", "protected", "public", "static", "yield"};
        strictModeReservedWords = SetsKt.setOf(stringArray);
        allReservedWords = SetsKt.plus(reservedWords, (Iterable)strictModeReservedWords);
    }
}

