/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.lower.AnnotationImplementationTransformer;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u0014H\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0012H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsAnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/lower/AnnotationImplementationTransformer;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "jsContext", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getJsContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "chooseConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "implClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitClassNew", "Lorg/jetbrains/kotlin/ir/IrStatement;", "arraysContentEquals", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "getArrayContentEqualsSymbol", "type", "implementAnnotationPropertiesAndConstructor", "", "annotationClass", "generatedConstructor", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsAnnotationImplementationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsAnnotationImplementationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsAnnotationImplementationTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1#2:72\n669#3,11:73\n*S KotlinDebug\n*F\n+ 1 JsAnnotationImplementationLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsAnnotationImplementationTransformer\n*L\n58#1:73,11\n*E\n"})
public final class JsAnnotationImplementationTransformer
extends AnnotationImplementationTransformer
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext jsContext;
    @NotNull
    private final Map<IrType, IrSimpleFunctionSymbol> arraysContentEquals;

    public JsAnnotationImplementationTransformer(@NotNull JsIrBackendContext jsContext) {
        Intrinsics.checkNotNullParameter(jsContext, "jsContext");
        super(jsContext, null);
        this.jsContext = jsContext;
        Map<IrType, IrSimpleFunctionSymbol> map = this.jsContext.getIr().getSymbols().getArraysContentEquals();
        if (map == null) {
            JsAnnotationImplementationTransformer jsAnnotationImplementationTransformer = this;
            boolean bl = false;
            JsAnnotationImplementationTransformer jsAnnotationImplementationTransformer2 = jsAnnotationImplementationTransformer;
            String string2 = "contentEquals symbols should be defined in JS IR context";
            throw new IllegalArgumentException(string2.toString());
        }
        this.arraysContentEquals = map;
    }

    @NotNull
    public final JsIrBackendContext getJsContext() {
        return this.jsContext;
    }

    @Override
    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        List<IrClass> list;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration instanceof IrClass && IrUtilsKt.isAnnotationClass((IrClass)declaration)) {
            IrStatement irStatement = this.visitClassNew((IrClass)declaration);
            Intrinsics.checkNotNull(irStatement, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            list = CollectionsKt.listOf((IrClass)irStatement);
        } else {
            list = null;
        }
        return list;
    }

    @Override
    @NotNull
    public IrExpression visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return expression2;
    }

    @Override
    @NotNull
    public IrConstructor chooseConstructor(@NotNull IrClass implClass, @NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter(implClass, "implClass");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        CompilationExceptionKt.compilationException("Should not be called", implClass);
        throw null;
    }

    @Override
    @NotNull
    public IrStatement visitClassNew(@NotNull IrClass declaration) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrClass $this$visitClassNew_u24lambda_u240 = irClass = declaration;
        boolean bl = false;
        if (IrUtilsKt.isAnnotationClass($this$visitClassNew_u24lambda_u240)) {
            this.implementGeneratedFunctions($this$visitClassNew_u24lambda_u240, $this$visitClassNew_u24lambda_u240);
        }
        this.addConstructorBodyForCompatibility($this$visitClassNew_u24lambda_u240);
        return irClass;
    }

    @Override
    @NotNull
    public IrSimpleFunctionSymbol getArrayContentEqualsSymbol(@NotNull IrType type2) {
        IrSimpleFunctionSymbol irSimpleFunctionSymbol;
        Intrinsics.checkNotNullParameter(type2, "type");
        if (IrTypeUtilsKt.isPrimitiveArray(type2) || IrTypeUtilsKt.isUnsignedArray(type2)) {
            irSimpleFunctionSymbol = this.arraysContentEquals.get(type2);
        } else {
            Object v1;
            block5: {
                Iterable $this$singleOrNull$iv = this.arraysContentEquals.entrySet();
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl = false;
                    IrType k = (IrType)entry.getKey();
                    if (!IrTypePredicatesKt.isArray(k)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block5;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            Map.Entry entry = v1;
            irSimpleFunctionSymbol = entry != null ? (IrSimpleFunctionSymbol)entry.getValue() : null;
        }
        if (irSimpleFunctionSymbol == null) {
            CompilationExceptionKt.compilationException("Can't find an Arrays.contentEquals method for array type", type2);
            throw null;
        }
        return irSimpleFunctionSymbol;
    }

    @Override
    public void implementAnnotationPropertiesAndConstructor(@NotNull IrClass implClass, @NotNull IrClass annotationClass, @NotNull IrConstructor generatedConstructor) {
        Intrinsics.checkNotNullParameter(implClass, "implClass");
        Intrinsics.checkNotNullParameter(annotationClass, "annotationClass");
        Intrinsics.checkNotNullParameter(generatedConstructor, "generatedConstructor");
        CompilationExceptionKt.compilationException("Should not be called", implClass);
        throw null;
    }
}

