/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrInlineUtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrReplSnippet;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrRichFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrRichPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;

@PhaseDescription(name="RecordEnclosingMethods")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/RecordEnclosingMethodsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
public final class RecordEnclosingMethodsLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public RecordEnclosingMethodsLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        irFile.accept((IrElementVisitor)new IrElementVisitor<Unit, IrFunction>(this){
            final /* synthetic */ RecordEnclosingMethodsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitElement(IrElement element, IrFunction data) {
                Intrinsics.checkNotNullParameter(element, "element");
                IrElementVisitor irElementVisitor = this;
                IrFunction irFunction = element instanceof IrFunction ? (IrFunction)element : null;
                if (irFunction == null) {
                    irFunction = data;
                }
                element.acceptChildren(irElementVisitor, irFunction);
            }

            public void visitFunctionAccess(IrFunctionAccessExpression expression2, IrFunction data) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                if (!(data != null)) {
                    boolean $i$a$-require-RecordEnclosingMethodsLowering$lower$1$visitFunctionAccess$22 = false;
                    String $i$a$-require-RecordEnclosingMethodsLowering$lower$1$visitFunctionAccess$22 = "function call not in a method: " + RenderIrElementKt.render$default(expression2, null, 1, null);
                    throw new IllegalArgumentException($i$a$-require-RecordEnclosingMethodsLowering$lower$1$visitFunctionAccess$22.toString());
                }
                if (Intrinsics.areEqual(expression2.getSymbol(), this.this$0.getContext().getIr().getSymbols().getIndyLambdaMetafactoryIntrinsic())) {
                    IrExpression reference2 = expression2.getValueArgument(1);
                    if (reference2 instanceof IrFunctionReference && IrUtilsKt.isLambda(((IrFunctionReference)reference2).getOrigin())) {
                        this.recordEnclosingMethodOverride(((IrFunctionSymbol)((IrFunctionReference)reference2).getSymbol()).getOwner(), data);
                    }
                } else if (JvmIrInlineUtilsKt.isInlineFunctionCall(((IrFunctionSymbol)expression2.getSymbol()).getOwner(), this.this$0.getContext())) {
                    for (IrValueParameter parameter : ((IrFunctionSymbol)expression2.getSymbol()).getOwner().getValueParameters()) {
                        IrExpression irExpression = expression2.getValueArgument(parameter.getIndexInOldValueParameters());
                        if (irExpression == null || (irExpression = JvmIrInlineUtilsKt.unwrapInlineLambda(irExpression)) == null) continue;
                        IrExpression lambda = irExpression;
                        this.recordEnclosingMethodOverride(((IrFunctionSymbol)((IrCallableReference)lambda).getSymbol()).getOwner(), data);
                    }
                }
                IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data);
            }

            private final void recordEnclosingMethodOverride(IrFunction from2, IrFunction to) {
                IrFunction old = JvmIrAttributesKt.getEnclosingMethodOverride(from2);
                if (old != null) {
                    boolean bl;
                    boolean bl2 = bl = Intrinsics.areEqual(IrUtilsKt.getParentAsClass(old), IrUtilsKt.getParentAsClass(to)) && old instanceof IrConstructor && to instanceof IrConstructor;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(IrUtilsKt.getParentAsClass(old));
                    if (irConstructor != null) {
                        IrConstructor it = irConstructor;
                        boolean bl3 = false;
                        JvmIrAttributesKt.setEnclosingMethodOverride(from2, it);
                    }
                } else {
                    JvmIrAttributesKt.setEnclosingMethodOverride(from2, to);
                }
            }

            public void visitDeclaration(IrDeclarationBase declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration, data);
            }

            public void visitValueParameter(IrValueParameter declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration, data);
            }

            public void visitClass(IrClass declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitClass(this, declaration, data);
            }

            public void visitAnonymousInitializer(IrAnonymousInitializer declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration, data);
            }

            public void visitTypeParameter(IrTypeParameter declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration, data);
            }

            public void visitFunction(IrFunction declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitFunction(this, declaration, data);
            }

            public void visitConstructor(IrConstructor declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitConstructor(this, declaration, data);
            }

            public void visitEnumEntry(IrEnumEntry declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration, data);
            }

            public void visitErrorDeclaration(IrErrorDeclaration declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration, data);
            }

            public void visitField(IrField declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitField(this, declaration, data);
            }

            public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data);
            }

            public void visitModuleFragment(IrModuleFragment declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration, data);
            }

            public void visitProperty(IrProperty declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitProperty(this, declaration, data);
            }

            public void visitScript(IrScript declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitScript(this, declaration, data);
            }

            public void visitReplSnippet(IrReplSnippet declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitReplSnippet(this, declaration, data);
            }

            public void visitSimpleFunction(IrSimpleFunction declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration, data);
            }

            public void visitTypeAlias(IrTypeAlias declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration, data);
            }

            public void visitVariable(IrVariable declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitVariable(this, declaration, data);
            }

            public void visitPackageFragment(IrPackageFragment declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration, data);
            }

            public void visitExternalPackageFragment(IrExternalPackageFragment declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration, data);
            }

            public void visitFile(IrFile declaration, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitFile(this, declaration, data);
            }

            public void visitExpression(IrExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data);
            }

            public void visitBody(IrBody body2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitBody(this, body2, data);
            }

            public void visitExpressionBody(IrExpressionBody body2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data);
            }

            public void visitBlockBody(IrBlockBody body2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data);
            }

            public void visitDeclarationReference(IrDeclarationReference expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data);
            }

            public void visitMemberAccess(IrMemberAccessExpression<?> expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data);
            }

            public void visitConstructorCall(IrConstructorCall expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data);
            }

            public void visitSingletonReference(IrGetSingletonValue expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data);
            }

            public void visitGetObjectValue(IrGetObjectValue expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data);
            }

            public void visitGetEnumValue(IrGetEnumValue expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data);
            }

            public void visitRawFunctionReference(IrRawFunctionReference expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data);
            }

            public void visitContainerExpression(IrContainerExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data);
            }

            public void visitBlock(IrBlock expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data);
            }

            public void visitComposite(IrComposite expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data);
            }

            public void visitReturnableBlock(IrReturnableBlock expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitReturnableBlock(this, expression2, data);
            }

            public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitInlinedFunctionBlock(this, inlinedBlock, data);
            }

            public void visitSyntheticBody(IrSyntheticBody body2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data);
            }

            public void visitBreakContinue(IrBreakContinue jump, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data);
            }

            public void visitBreak(IrBreak jump, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitBreak(this, jump, data);
            }

            public void visitContinue(IrContinue jump, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitContinue(this, jump, data);
            }

            public void visitCall(IrCall expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitCall(this, expression2, data);
            }

            public void visitCallableReference(IrCallableReference<?> expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data);
            }

            public void visitFunctionReference(IrFunctionReference expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data);
            }

            public void visitPropertyReference(IrPropertyReference expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data);
            }

            public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data);
            }

            public void visitRichFunctionReference(IrRichFunctionReference expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitRichFunctionReference(this, expression2, data);
            }

            public void visitRichPropertyReference(IrRichPropertyReference expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitRichPropertyReference(this, expression2, data);
            }

            public void visitClassReference(IrClassReference expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data);
            }

            public void visitConst(IrConst expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitConst(this, expression2, data);
            }

            public void visitConstantValue(IrConstantValue expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitConstantValue(this, expression2, data);
            }

            public void visitConstantPrimitive(IrConstantPrimitive expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitConstantPrimitive(this, expression2, data);
            }

            public void visitConstantObject(IrConstantObject expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitConstantObject(this, expression2, data);
            }

            public void visitConstantArray(IrConstantArray expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitConstantArray(this, expression2, data);
            }

            public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data);
            }

            public void visitDynamicExpression(IrDynamicExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data);
            }

            public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data);
            }

            public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data);
            }

            public void visitEnumConstructorCall(IrEnumConstructorCall expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data);
            }

            public void visitErrorExpression(IrErrorExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data);
            }

            public void visitErrorCallExpression(IrErrorCallExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data);
            }

            public void visitFieldAccess(IrFieldAccessExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data);
            }

            public void visitGetField(IrGetField expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data);
            }

            public void visitSetField(IrSetField expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data);
            }

            public void visitFunctionExpression(IrFunctionExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data);
            }

            public void visitGetClass(IrGetClass expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data);
            }

            public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data);
            }

            public void visitLoop(IrLoop loop, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitLoop(this, loop, data);
            }

            public void visitWhileLoop(IrWhileLoop loop, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop, data);
            }

            public void visitDoWhileLoop(IrDoWhileLoop loop, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop, data);
            }

            public void visitReturn(IrReturn expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data);
            }

            public void visitStringConcatenation(IrStringConcatenation expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data);
            }

            public void visitSuspensionPoint(IrSuspensionPoint expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data);
            }

            public void visitSuspendableExpression(IrSuspendableExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data);
            }

            public void visitThrow(IrThrow expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data);
            }

            public void visitTry(IrTry aTry, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitTry(this, aTry, data);
            }

            public void visitCatch(IrCatch aCatch, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data);
            }

            public void visitTypeOperator(IrTypeOperatorCall expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data);
            }

            public void visitValueAccess(IrValueAccessExpression expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data);
            }

            public void visitGetValue(IrGetValue expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data);
            }

            public void visitSetValue(IrSetValue expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data);
            }

            public void visitVararg(IrVararg expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data);
            }

            public void visitSpreadElement(IrSpreadElement spread, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data);
            }

            public void visitWhen(IrWhen expression2, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data);
            }

            public void visitBranch(IrBranch branch, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitBranch(this, branch, data);
            }

            public void visitElseBranch(IrElseBranch branch, IrFunction data) {
                IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data);
            }
        }, null);
    }
}

