/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.execution;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.eclipse.aether.SessionData;
import org.eclipse.sisu.Typed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
@Typed(value={EventSpy.class})
public class LockingEventSpy
extends AbstractEventSpy {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final Object LOCKS_KEY = new Object();

    private Lock getLock(ExecutionEvent event) {
        SessionData data = event.getSession().getRepositorySession().getData();
        Map locks = (Map)data.get(LOCKS_KEY);
        if (locks == null) {
            data.set(LOCKS_KEY, null, new ConcurrentHashMap());
            locks = (Map)data.get(LOCKS_KEY);
        }
        return locks.computeIfAbsent(event.getProject(), p -> new ReentrantLock());
    }

    public void onEvent(Object event) throws Exception {
        if (event instanceof ExecutionEvent) {
            ExecutionEvent executionEvent = (ExecutionEvent)event;
            switch (executionEvent.getType()) {
                case ProjectStarted: 
                case ForkedProjectStarted: {
                    Lock lock = this.getLock(executionEvent);
                    if (lock.tryLock()) break;
                    this.logger.warn("Suspending concurrent execution of project '{}'", (Object)executionEvent.getProject());
                    lock.lockInterruptibly();
                    this.logger.warn("Resuming execution of project '{}'", (Object)executionEvent.getProject());
                    break;
                }
                case ProjectSucceeded: 
                case ProjectFailed: 
                case ForkedProjectSucceeded: 
                case ForkedProjectFailed: {
                    this.getLock(executionEvent).unlock();
                }
            }
        }
    }
}

