/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.timing;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.sisu.Typed;
import org.mvndaemon.mvnd.common.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="timing")
@Typed(value={EventSpy.class})
public class BuildTimeEventSpy
extends AbstractEventSpy {
    public static final int MAX_NAME_LENGTH = 58;
    public static final String DIVIDER = "------------------------------------------------------------------------";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Session session;

    private static String getExecutionProperty(ExecutionEvent event, String property, String def) {
        MavenSession mavenSession = event.getSession();
        Properties systemProperties = mavenSession.getSystemProperties();
        Properties userProperties = mavenSession.getUserProperties();
        String output = userProperties.getProperty(property);
        output = output == null ? systemProperties.getProperty(property) : output;
        return output == null ? def : output;
    }

    public void init(EventSpy.Context context) throws Exception {
        super.init(context);
    }

    public void onEvent(Object event) throws Exception {
        if (event instanceof ExecutionEvent) {
            this.onEvent((ExecutionEvent)event);
        }
    }

    private void onEvent(ExecutionEvent event) throws Exception {
        switch (event.getType()) {
            case SessionStarted: {
                this.logger.info("BuildTimeEventSpy is registered.");
                this.session = new Session();
                break;
            }
            case MojoStarted: {
                this.session.mojoTimer(event).start();
                break;
            }
            case MojoFailed: 
            case MojoSucceeded: {
                this.session.mojoTimer(event).end();
                break;
            }
            case SessionEnded: {
                String prop = BuildTimeEventSpy.getExecutionProperty(event, Environment.MVND_BUILD_TIME.getProperty(), Environment.MVND_BUILD_TIME.getDefault());
                boolean output = Boolean.parseBoolean(prop);
                this.doReport(output);
                break;
            }
        }
    }

    public void close() throws Exception {
        super.close();
    }

    private void doReport(boolean output) {
        Consumer<String> log = output ? arg_0 -> ((Logger)this.logger).info(arg_0) : arg_0 -> ((Logger)this.logger).debug(arg_0);
        log.accept(DIVIDER);
        log.accept("Build Time Summary:");
        log.accept(DIVIDER);
        HashMap<String, Long> mojos = new HashMap<String, Long>();
        this.session.projects().forEach(p -> {
            log.accept(String.format("%s [%.3fs]", p.name(), (double)p.duration() / 1000.0));
            p.mojos().forEach(m -> {
                log.accept(String.format("  %s [%.3fs]", m.name(), (double)m.duration() / 1000.0));
                mojos.merge(m.name(), m.duration(), Long::sum);
            });
        });
        log.accept(DIVIDER);
        mojos.forEach((name, duration) -> log.accept(String.format("  %s [%.3fs]", name, (double)duration.longValue() / 1000.0)));
    }

    private static class Session {
        private final Map<String, Map<String, Timer>> session = new ConcurrentHashMap<String, Map<String, Timer>>();

        private Session() {
        }

        public Stream<Project> projects() {
            return this.session.entrySet().stream().map(Project::new).sorted(Comparator.comparing(Project::startTime));
        }

        public Timer mojoTimer(ExecutionEvent event) {
            return this.session.computeIfAbsent(event.getProject().getArtifactId(), id -> new ConcurrentHashMap()).computeIfAbsent(this.name(event.getMojoExecution()), mn -> new Timer());
        }

        private String name(MojoExecution mojoExecution) {
            return String.format(Locale.ENGLISH, "%s:%s (%s)", mojoExecution.getArtifactId(), mojoExecution.getGoal(), mojoExecution.getExecutionId());
        }
    }

    private static class Timer {
        private long startTime = 0L;
        private long endTime = 0L;

        private Timer() {
        }

        public long startTime() {
            return this.startTime;
        }

        public long endTime() {
            return this.endTime;
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public void end() {
            this.endTime = System.currentTimeMillis();
        }
    }

    private static class Project {
        private final Map.Entry<String, Map<String, Timer>> project;

        Project(Map.Entry<String, Map<String, Timer>> project) {
            this.project = project;
        }

        public String name() {
            return this.project.getKey();
        }

        public long duration() {
            return this.endTime() - this.startTime();
        }

        public long startTime() {
            return this.project.getValue().values().stream().mapToLong(Timer::startTime).min().orElse(0L);
        }

        public long endTime() {
            return this.project.getValue().values().stream().mapToLong(Timer::endTime).max().orElse(0L);
        }

        public Stream<Mojo> mojos() {
            return this.project.getValue().entrySet().stream().map(Mojo::new).sorted(Comparator.comparing(Mojo::startTime));
        }
    }

    private static class Mojo {
        private final Map.Entry<String, Timer> mojo;

        Mojo(Map.Entry<String, Timer> mojo) {
            this.mojo = mojo;
        }

        public String name() {
            String name = this.mojo.getKey();
            String truncatedName = name.length() >= 58 ? StringUtils.substring((String)name, (int)0, (int)58) : name + " ";
            return StringUtils.rightPad((String)truncatedName, (int)58, (String)".");
        }

        public long duration() {
            return this.endTime() - this.startTime();
        }

        public long startTime() {
            return this.mojo.getValue().startTime();
        }

        public long endTime() {
            return this.mojo.getValue().endTime();
        }
    }
}

