/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.Stack;

public final class MutableExceptionCheck
extends AbstractFormatCheck {
    private static final String DEFAULT_FORMAT = "^.*Exception$|^.*Error$";
    private final Stack mCheckingStack = new Stack();
    private boolean mChecking;

    public MutableExceptionCheck() {
        super(DEFAULT_FORMAT);
    }

    public int[] getDefaultTokens() {
        return new int[]{14, 10};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 14: {
                this.visitClassDef(aAST);
                break;
            }
            case 10: {
                this.visitVariableDef(aAST);
                break;
            }
            default: {
                throw new IllegalStateException(aAST.toString());
            }
        }
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 14: {
                this.leaveClassDef();
                break;
            }
        }
    }

    private void visitClassDef(DetailAST aAST) {
        this.mCheckingStack.push(this.mChecking ? Boolean.TRUE : Boolean.FALSE);
        this.mChecking = this.isExceptionClass(aAST.findFirstToken(58).getText());
    }

    private void leaveClassDef() {
        this.mChecking = (Boolean)this.mCheckingStack.pop();
    }

    private void visitVariableDef(DetailAST aAST) {
        DetailAST modifiersAST;
        if (this.mChecking && aAST.getParent().getType() == 6 && (modifiersAST = aAST.findFirstToken(5)).findFirstToken(39) == null) {
            this.log(aAST.getLineNo(), aAST.getColumnNo(), "mutable.exception", (Object)aAST.findFirstToken(58).getText());
        }
    }

    private boolean isExceptionClass(String aClassName) {
        return this.getRegexp().match(aClassName);
    }
}

