/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.lucene.demo.html.Entities;
import org.apache.lucene.demo.html.HTMLParserConstants;
import org.apache.lucene.demo.html.HTMLParserTokenManager;
import org.apache.lucene.demo.html.ParseException;
import org.apache.lucene.demo.html.ParserThread;
import org.apache.lucene.demo.html.SimpleCharStream;
import org.apache.lucene.demo.html.Tags;
import org.apache.lucene.demo.html.Token;

public class HTMLParser
implements HTMLParserConstants {
    public static int SUMMARY_LENGTH = 200;
    StringBuffer title = new StringBuffer(SUMMARY_LENGTH);
    StringBuffer summary = new StringBuffer(SUMMARY_LENGTH * 2);
    Properties metaTags = new Properties();
    String currentMetaTag = null;
    String currentMetaContent = null;
    int length = 0;
    boolean titleComplete = false;
    boolean inTitle = false;
    boolean inMetaTag = false;
    boolean inStyle = false;
    boolean afterTag = false;
    boolean afterSpace = false;
    String eol = System.getProperty("line.separator");
    Reader pipeIn = null;
    Writer pipeOut;
    private MyPipedInputStream pipeInStream = null;
    private PipedOutputStream pipeOutStream = null;
    public HTMLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[14];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[2];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTitle() throws IOException, InterruptedException {
        if (this.pipeIn == null) {
            this.getReader();
        }
        while (true) {
            HTMLParser hTMLParser = this;
            synchronized (hTMLParser) {
                if (this.titleComplete || this.pipeInStream.full()) {
                    break;
                }
                this.wait(10L);
            }
        }
        return this.title.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getMetaTags() throws IOException, InterruptedException {
        if (this.pipeIn == null) {
            this.getReader();
        }
        while (true) {
            HTMLParser hTMLParser = this;
            synchronized (hTMLParser) {
                if (this.titleComplete || this.pipeInStream.full()) {
                    break;
                }
                this.wait(10L);
            }
        }
        return this.metaTags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSummary() throws IOException, InterruptedException {
        String tit;
        String sum;
        if (this.pipeIn == null) {
            this.getReader();
        }
        while (true) {
            HTMLParser hTMLParser = this;
            synchronized (hTMLParser) {
                if (this.summary.length() >= SUMMARY_LENGTH || this.pipeInStream.full()) {
                    break;
                }
                this.wait(10L);
            }
        }
        if (this.summary.length() > SUMMARY_LENGTH) {
            this.summary.setLength(SUMMARY_LENGTH);
        }
        if ((sum = this.summary.toString().trim()).startsWith(tit = this.getTitle()) || sum.equals("")) {
            return tit;
        }
        return sum;
    }

    public Reader getReader() throws IOException {
        if (this.pipeIn == null) {
            this.pipeInStream = new MyPipedInputStream();
            this.pipeOutStream = new PipedOutputStream(this.pipeInStream);
            this.pipeIn = new InputStreamReader((InputStream)this.pipeInStream, "UTF-16BE");
            this.pipeOut = new OutputStreamWriter((OutputStream)this.pipeOutStream, "UTF-16BE");
            ParserThread thread = new ParserThread(this);
            thread.start();
        }
        return this.pipeIn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToSummary(String text) {
        if (this.summary.length() < SUMMARY_LENGTH) {
            this.summary.append(text);
            if (this.summary.length() >= SUMMARY_LENGTH) {
                HTMLParser hTMLParser = this;
                synchronized (hTMLParser) {
                    this.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addText(String text) throws IOException {
        if (this.inStyle) {
            return;
        }
        if (this.inTitle) {
            this.title.append(text);
        } else {
            this.addToSummary(text);
            if (!this.titleComplete && !this.title.equals("")) {
                HTMLParser hTMLParser = this;
                synchronized (hTMLParser) {
                    this.titleComplete = true;
                    this.notifyAll();
                }
            }
        }
        this.length += text.length();
        this.pipeOut.write(text);
        this.afterSpace = false;
    }

    void addMetaTag() {
        this.metaTags.setProperty(this.currentMetaTag, this.currentMetaContent);
        this.currentMetaTag = null;
        this.currentMetaContent = null;
    }

    void addSpace() throws IOException {
        if (!this.afterSpace) {
            if (this.inTitle) {
                this.title.append(" ");
            } else {
                this.addToSummary(" ");
            }
            String space = this.afterTag ? this.eol : " ";
            this.length += space.length();
            this.pipeOut.write(space);
            this.afterSpace = true;
        }
    }

    public final void HTMLDocument() throws ParseException, IOException {
        block14: {
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 10: 
                    case 11: 
                    case 13: {
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                        break block14;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: {
                        this.Tag();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 3: {
                        Token t = this.Decl();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 4: 
                    case 5: {
                        this.CommentTag();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 1: {
                        this.ScriptTag();
                        this.afterTag = true;
                        continue block13;
                    }
                    case 6: {
                        Token t = this.jj_consume_token(6);
                        this.addText(t.image);
                        this.afterTag = false;
                        continue block13;
                    }
                    case 10: {
                        Token t = this.jj_consume_token(10);
                        this.addText(Entities.decode(t.image));
                        this.afterTag = false;
                        continue block13;
                    }
                    case 13: {
                        Token t = this.jj_consume_token(13);
                        this.addText(t.image);
                        this.afterTag = false;
                        continue block13;
                    }
                    case 11: {
                        this.jj_consume_token(11);
                        this.addSpace();
                        this.afterTag = false;
                        continue block13;
                    }
                }
                break;
            }
            this.jj_la1[1] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
    }

    public final void Tag() throws ParseException, IOException {
        boolean inImg = false;
        Token t1 = this.jj_consume_token(2);
        String tagName = t1.image.toLowerCase();
        if (Tags.WS_ELEMS.contains(tagName)) {
            this.addSpace();
        }
        this.inTitle = tagName.equalsIgnoreCase("<title");
        this.inMetaTag = tagName.equalsIgnoreCase("<META");
        this.inStyle = tagName.equalsIgnoreCase("<STYLE");
        inImg = tagName.equalsIgnoreCase("<img");
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 16: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block9;
                }
            }
            t1 = this.jj_consume_token(16);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 17: {
                    this.jj_consume_token(17);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 19: 
                        case 20: 
                        case 21: {
                            Token t2 = this.ArgValue();
                            if (inImg && t1.image.equalsIgnoreCase("alt") && t2 != null) {
                                this.addText("[" + t2.image + "]");
                            }
                            if (this.inMetaTag && (t1.image.equalsIgnoreCase("name") || t1.image.equalsIgnoreCase("HTTP-EQUIV")) && t2 != null) {
                                this.currentMetaTag = t2.image.toLowerCase();
                                if (this.currentMetaTag != null && this.currentMetaContent != null) {
                                    this.addMetaTag();
                                }
                            }
                            if (!this.inMetaTag || !t1.image.equalsIgnoreCase("content") || t2 == null) continue block9;
                            this.currentMetaContent = t2.image.toLowerCase();
                            if (this.currentMetaTag == null || this.currentMetaContent == null) continue block9;
                            this.addMetaTag();
                            continue block9;
                        }
                    }
                    this.jj_la1[3] = this.jj_gen;
                    continue block9;
                }
            }
            this.jj_la1[4] = this.jj_gen;
        }
        this.jj_consume_token(18);
    }

    public final Token ArgValue() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                t = this.jj_consume_token(19);
                return t;
            }
        }
        this.jj_la1[5] = this.jj_gen;
        if (this.jj_2_1(2)) {
            this.jj_consume_token(20);
            this.jj_consume_token(24);
            return t;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.jj_consume_token(20);
                t = this.jj_consume_token(23);
                this.jj_consume_token(24);
                return t;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        if (this.jj_2_2(2)) {
            this.jj_consume_token(21);
            this.jj_consume_token(26);
            return t;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                t = this.jj_consume_token(25);
                this.jj_consume_token(26);
                return t;
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token Decl() throws ParseException {
        Token t;
        block9: {
            t = this.jj_consume_token(3);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        this.jj_consume_token(16);
                        continue block8;
                    }
                    case 19: 
                    case 20: 
                    case 21: {
                        this.ArgValue();
                        continue block8;
                    }
                    case 17: {
                        this.jj_consume_token(17);
                        continue block8;
                    }
                }
                break;
            }
            this.jj_la1[9] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(18);
        return t;
    }

    public final void CommentTag() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 4: {
                this.jj_consume_token(4);
                block10: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.jj_consume_token(27);
                }
                this.jj_consume_token(28);
                break;
            }
            case 5: {
                this.jj_consume_token(5);
                block11: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 29: {
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                            break block11;
                        }
                    }
                    this.jj_consume_token(29);
                }
                this.jj_consume_token(30);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ScriptTag() throws ParseException {
        this.jj_consume_token(1);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(14);
        }
        this.jj_consume_token(15);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private final boolean jj_3_2() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{11390, 11390, 65536, 0x380000, 131072, 524288, 0x100000, 0x200000, 0x3B0000, 0x3B0000, 0x8000000, 0x20000000, 48, 16384};
    }

    public HTMLParser(InputStream stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new HTMLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public HTMLParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new HTMLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public HTMLParser(HTMLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(HTMLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 14; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[31];
        for (i = 0; i < 31; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 14; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 31; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 2; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        HTMLParser.jj_la1_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    private class MyPipedInputStream
    extends PipedInputStream {
        public MyPipedInputStream() {
        }

        public MyPipedInputStream(PipedOutputStream src) throws IOException {
            super(src);
        }

        public boolean full() throws IOException {
            return this.available() >= 1024;
        }
    }
}

