/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.bouncycastle.mail.smime.util.SharedFileInputStream;

public class FileBackedMimeBodyPart
extends MimeBodyPart {
    private final File _file;

    public FileBackedMimeBodyPart(File file) throws MessagingException, IOException {
        super((InputStream)new SharedFileInputStream(file));
        this._file = file;
    }

    public void writeTo(OutputStream outputStream) throws IOException, MessagingException {
        if (!this._file.exists()) {
            throw new IOException("file " + this._file.getCanonicalPath() + " no longer exists.");
        }
        super.writeTo(outputStream);
    }

    public void dispose() throws IOException {
        ((SharedFileInputStream)this.contentStream).dispose();
        if (!this._file.delete()) {
            throw new IOException("deletion of underlying file <" + this._file.getCanonicalPath() + "> failed.");
        }
    }
}

