/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractArrayConverter;

final class StrArrayConverter
extends AbstractArrayConverter {
    private static final String[] MODEL = new String[0];

    public StrArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public StrArrayConverter(Object aDefaultValue) {
        this.defaultValue = aDefaultValue;
        this.useDefault = true;
    }

    public Object convert(Class aType, Object aValue) throws ConversionException {
        if (aValue == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (MODEL.getClass() == aValue.getClass()) {
            return aValue;
        }
        try {
            List list = this.parseElements(aValue.toString());
            String[] results = new String[list.size()];
            for (int i = 0; i < results.length; ++i) {
                results[i] = (String)list.get(i);
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(aValue.toString(), e);
        }
    }

    protected List parseElements(String aValue) throws NullPointerException {
        if (aValue == null) {
            throw new NullPointerException();
        }
        String str = aValue.trim();
        if (str.startsWith("{") && str.endsWith("}")) {
            str = str.substring(1, str.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(str, ",");
        ArrayList<String> retVal = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            retVal.add(token.trim());
        }
        return retVal;
    }
}

