/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignerInfo;

public class SignedData
extends ASN1Encodable {
    private DERInteger version;
    private ASN1Set digestAlgorithms;
    private ContentInfo contentInfo;
    private ASN1Set certificates;
    private ASN1Set crls;
    private ASN1Set signerInfos;
    private boolean certBer;
    private boolean crlsBer;

    public static SignedData getInstance(Object object) {
        if (object instanceof SignedData) {
            return (SignedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new SignedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public SignedData(ASN1Set aSN1Set, ContentInfo contentInfo, ASN1Set aSN1Set2, ASN1Set aSN1Set3, ASN1Set aSN1Set4) {
        if (contentInfo.getContentType().equals(CMSObjectIdentifiers.data)) {
            Enumeration enumeration = aSN1Set4.getObjects();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(enumeration.nextElement());
                if (signerInfo.getVersion().getValue().intValue() != 3) continue;
                bl = true;
            }
            this.version = bl ? new DERInteger(3) : new DERInteger(1);
        } else {
            this.version = new DERInteger(3);
        }
        this.digestAlgorithms = aSN1Set;
        this.contentInfo = contentInfo;
        this.certificates = aSN1Set2;
        this.crls = aSN1Set3;
        this.signerInfos = aSN1Set4;
    }

    public SignedData(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.version = (DERInteger)enumeration.nextElement();
        this.digestAlgorithms = (ASN1Set)enumeration.nextElement();
        this.contentInfo = ContentInfo.getInstance(enumeration.nextElement());
        block4: while (enumeration.hasMoreElements()) {
            DERObject dERObject = (DERObject)enumeration.nextElement();
            if (dERObject instanceof ASN1TaggedObject) {
                ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)dERObject;
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.certBer = aSN1TaggedObject instanceof BERTaggedObject;
                        this.certificates = ASN1Set.getInstance(aSN1TaggedObject, false);
                        continue block4;
                    }
                    case 1: {
                        this.crlsBer = aSN1TaggedObject instanceof BERTaggedObject;
                        this.crls = ASN1Set.getInstance(aSN1TaggedObject, false);
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("unknown tag value " + aSN1TaggedObject.getTagNo());
            }
            this.signerInfos = (ASN1Set)dERObject;
        }
    }

    public DERInteger getVersion() {
        return this.version;
    }

    public ASN1Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public ContentInfo getEncapContentInfo() {
        return this.contentInfo;
    }

    public ASN1Set getCertificates() {
        return this.certificates;
    }

    public ASN1Set getCRLs() {
        return this.crls;
    }

    public ASN1Set getSignerInfos() {
        return this.signerInfos;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.digestAlgorithms);
        aSN1EncodableVector.add(this.contentInfo);
        if (this.certificates != null) {
            if (this.certBer) {
                aSN1EncodableVector.add(new BERTaggedObject(false, 0, this.certificates));
            } else {
                aSN1EncodableVector.add(new DERTaggedObject(false, 0, this.certificates));
            }
        }
        if (this.crls != null) {
            if (this.crlsBer) {
                aSN1EncodableVector.add(new BERTaggedObject(false, 1, this.crls));
            } else {
                aSN1EncodableVector.add(new DERTaggedObject(false, 1, this.crls));
            }
        }
        aSN1EncodableVector.add(this.signerInfos);
        return new BERSequence(aSN1EncodableVector);
    }
}

