/* PgSqlClient - ADO.NET Data Provider for PostgreSQL 7.4+
 * Copyright (c) 2003-2004 Carlos Guzman Alvarez
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Data;
using System.Text;

namespace PostgreSql.Data.PgSqlClient.DbSchema
{
	internal class PgFunctionsSchema : PgAbstractDbSchema
	{
		#region Constructors

		public PgFunctionsSchema() : base("Functions")
		{
		}

		#endregion

		#region Add Methods

		public override void AddTables()
		{
			AddTable("pg_proc");
		}

		public override void AddRestrictionColumns()
		{
			AddRestrictionColumn("pg_namespace.nspname"	, "FUNCTION_SCHEMA", null);
			AddRestrictionColumn("pg_proc.proname"		, "FUNCTION_NAME", null);
		}

		public override void AddDataColumns()
		{
			AddDataColumn("pg_language.lanname"	, "PROCEDURE_LANGUAGE");
			AddDataColumn("pg_proc.proisagg"	, "IS_AGGREGATE");
			AddDataColumn("pg_proc.prosecdef"	, "IS_SECURITY_DEFINER");
			AddDataColumn("pg_proc.proisstrict"	, "IS_STRICT");
			AddDataColumn(getVolatileExpression("pg_proc.provolatile")	, "VOLATILE");
			AddDataColumn("pg_proc.proretset"	, "RETURNS_SET");
			AddDataColumn("pg_proc.prorettype"	, "RETURN_TYPE");
			AddDataColumn("pg_proc.pronargs"	, "ARGUMENT_NUMBER");
			AddDataColumn("pg_proc.proargtypes"	, "ARGUMENTS");
			AddDataColumn("pg_proc.prosrc"		, "SOURCE");
			AddDataColumn("pg_description.description", "DESCRIPTION");
		}

		public override void AddJoins()
		{
			AddJoin("left join", "pg_namespace"	, "pg_proc.pronamespace = pg_namespace.oid");
			AddJoin("left join", "pg_language"	, "pg_proc.prolang = pg_language.oid");		
			AddJoin("left join", "pg_description", "pg_proc.oid = pg_description.objoid");
		}

		public override void AddOrderByColumns()
		{
			AddOrderBy("pg_namespace.nspname");
			AddOrderBy("pg_proc.proname");
		}

		public override void AddWhereFilters()
		{
		}

		#endregion

		#region Parse Methods

		public override object[] ParseRestrictions(object[] restrictions)
		{
			object[] parsed = restrictions;

			return parsed;
		}

		#endregion

		#region Private Methods

		private string getVolatileExpression(string fieldName)
		{
			StringBuilder expression = new StringBuilder();

			expression.AppendFormat(" case {0} ", fieldName);
			expression.Append(" when 'i' THEN 'INMUTABLE'");
			expression.Append(" when 's' THEN 'STABLE'");
			expression.Append(" when 'v' THEN 'VOLATILE'");
			expression.Append(" END ");

			return expression.ToString();
		}

		#endregion
	}
}