/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.List;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.api.PSystemFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.error.PSystemErrorUtils;
import net.sourceforge.plantuml.utils.LineLocation;
import net.sourceforge.plantuml.utils.StringLocated;

public abstract class PSystemAbstractFactory
implements PSystemFactory {
    public static final String EMPTY_DESCRIPTION = "Empty description";
    private final DiagramType type;

    protected PSystemAbstractFactory(DiagramType type) {
        this.type = type;
    }

    protected final PSystemError buildEmptyError(UmlSource source, LineLocation lineLocation, List<StringLocated> trace) {
        ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, EMPTY_DESCRIPTION, 0, lineLocation);
        PSystemError result = PSystemErrorUtils.buildV2(source, err, null, trace);
        return result;
    }

    protected final PSystemError buildExecutionError(UmlSource source, String stringError, LineLocation lineLocation, List<StringLocated> trace) {
        ErrorUml err = new ErrorUml(ErrorUmlType.EXECUTION_ERROR, stringError, 0, lineLocation);
        PSystemError result = PSystemErrorUtils.buildV2(source, err, null, trace);
        return result;
    }

    @Override
    public final DiagramType getDiagramType() {
        return this.type;
    }
}

