/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.baraye.EntityImp;
import net.sourceforge.plantuml.baraye.EntityUtils;
import net.sourceforge.plantuml.baraye.IGroup;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.ICucaDiagram;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2InternalImage;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.InnerStateAutonom;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public final class GroupPngMakerState {
    private final ICucaDiagram diagram;
    private final IGroup group;
    private final StringBounder stringBounder;

    public GroupPngMakerState(ICucaDiagram diagram, IGroup group, StringBounder stringBounder) {
        this.diagram = diagram;
        this.stringBounder = stringBounder;
        this.group = group;
        if (!group.isGroup()) {
            throw new IllegalArgumentException();
        }
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            if (!EntityUtils.isPureInnerLink12(this.group, link)) continue;
            result.add(link);
        }
        return result;
    }

    public IEntityImage getImage() {
        UStroke stroke;
        Display display = this.group.getDisplay();
        ISkinParam skinParam = this.diagram.getSkinParam();
        Style style = EntityImageStateCommon.getStyleState(this.group, skinParam);
        Style styleTitle = EntityImageStateCommon.getStyleStateTitle(this.group, skinParam);
        Style styleBody = EntityImageStateCommon.getStyleStateBody(this.group, skinParam);
        double rounded = style.value(PName.RoundCorner).asDouble();
        double shadowing = style.value(PName.Shadowing).asDouble();
        FontConfiguration titleFontConfiguration = styleTitle.getFontConfiguration(skinParam.getIHtmlColorSet());
        TextBlock title = display.create(titleFontConfiguration, HorizontalAlignment.CENTER, this.diagram.getSkinParam());
        if (this.group.size() == 0 && this.group.getChildren().size() == 0) {
            return new EntityImageState(this.group, this.diagram.getSkinParam());
        }
        List<Link> links = this.getPureInnerLinks();
        DotData dotData = new DotData(this.group, links, this.group.getLeafsDirect(), this.diagram.getUmlDiagramType(), skinParam, new InnerGroupHierarchy(), this.diagram.getEntityFactory(), this.diagram.isHideEmptyDescriptionForState(), DotMode.NORMAL, this.diagram.getNamespaceSeparator(), this.diagram.getPragma());
        GeneralImageBuilder svek2 = new GeneralImageBuilder(dotData, this.diagram.getEntityFactory(), this.diagram.getSource(), this.diagram.getPragma(), this.stringBounder, SName.stateDiagram);
        if (this.group.getGroupType() == GroupType.CONCURRENT_STATE) {
            return svek2.buildImage(null, new String[0]);
        }
        if (this.group.getGroupType() != GroupType.STATE) {
            throw new UnsupportedOperationException(this.group.getGroupType().toString());
        }
        HColor borderColor = this.group.getColors().getColor(ColorType.LINE);
        if (borderColor == null) {
            borderColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        }
        Stereotype stereo = this.group.getStereotype();
        HColor backColor = this.group.getColors().getColor(ColorType.BACK);
        if (backColor == null) {
            backColor = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        }
        if ((stroke = this.group.getColors().getSpecificLineStroke()) == null) {
            stroke = style.getStroke();
        }
        TextBlock attribute = ((EntityImp)this.group).getStateHeader(skinParam);
        Stereotype stereotype = this.group.getStereotype();
        boolean withSymbol = stereotype != null && stereotype.isWithOOSymbol();
        boolean containsOnlyConcurrentStates = this.containsOnlyConcurrentStates(dotData);
        IEntityImage image = containsOnlyConcurrentStates ? this.buildImageForConcurrentState(dotData) : svek2.buildImage(null, new String[0]);
        HColor bodyColor = styleBody.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        return new InnerStateAutonom(image, title, attribute, borderColor, backColor, this.group.getUrl99(), withSymbol, stroke, rounded, shadowing, bodyColor);
    }

    private IEntityImage buildImageForConcurrentState(DotData dotData) {
        ArrayList<IEntityImage> inners = new ArrayList<IEntityImage>();
        for (ILeaf inner : dotData.getLeafs()) {
            inners.add(inner.getSvekImage());
        }
        return new CucaDiagramFileMakerSvek2InternalImage(inners, dotData.getTopParent().getConcurrentSeparator(), dotData.getSkinParam(), this.group.getStereotype());
    }

    private boolean containsOnlyConcurrentStates(DotData dotData) {
        for (ILeaf leaf : dotData.getLeafs()) {
            if (!(leaf instanceof IGroup)) {
                return false;
            }
            if (((IGroup)((Object)leaf)).getLeafType() == LeafType.STATE_CONCURRENT) continue;
            return false;
        }
        return true;
    }

    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public IGroup getRootGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<IGroup> getChildrenGroups(IGroup parent) {
            if (EntityUtils.groupRoot(parent)) {
                return GroupPngMakerState.this.diagram.getChildrenGroups(GroupPngMakerState.this.group);
            }
            return GroupPngMakerState.this.diagram.getChildrenGroups(parent);
        }

        @Override
        public boolean isEmpty(IGroup g) {
            return GroupPngMakerState.this.diagram.isEmpty(g);
        }
    }
}

