/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.timingdiagram.command.TimeTickBuilder;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandAtTime
extends SingleLineCommand2<TimingDiagram> {
    public CommandAtTime() {
        super(CommandAtTime.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandAtTime.class.getName(), RegexLeaf.start(), TimeTickBuilder.expressionAtWithArobase("TIME"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf(":"), new RegexLeaf("CODE", "([%pLN_.]+)"))), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        TimeTick timeTick = TimeTickBuilder.parseTimeTick("TIME", arg, diagram);
        if (timeTick == null) {
            return CommandExecutionResult.error("What time?");
        }
        String code = arg.get("CODE", 0);
        diagram.addTime(timeTick, code);
        return CommandExecutionResult.ok();
    }
}

