/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.util.Map;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGoto;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileLabel;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.klimt.UChange;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicDelegator;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.svek.UGraphicForSnake;

public class UGraphicInterceptorUDrawable2
extends UGraphicDelegator {
    private final Map<String, UTranslate> positions;

    public UGraphicInterceptorUDrawable2(UGraphic ug, Map<String, UTranslate> positions) {
        super(ug);
        this.positions = positions;
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof Gtile) {
            Gtile gtile = (Gtile)shape;
            gtile.drawU(this);
        } else if (shape instanceof Ftile) {
            Ftile ftile = (Ftile)shape;
            ftile.drawU(this);
            if (ftile instanceof FtileLabel) {
                this.positions.put(((FtileLabel)ftile).getName(), this.getPosition());
            }
            if (ftile instanceof FtileGoto) {
                this.drawGoto((FtileGoto)ftile);
            }
        } else if (shape instanceof UDrawable) {
            UDrawable drawable = (UDrawable)((Object)shape);
            drawable.drawU(this);
        } else {
            this.getUg().draw(shape);
        }
    }

    private UTranslate getPosition() {
        return ((UGraphicForSnake)this.getUg()).getTranslation();
    }

    private void drawGoto(FtileGoto ftile) {
        HColor gotoColor = HColors.MY_RED;
        FtileGeometry geom = ftile.calculateDimension(this.getStringBounder());
        XPoint2D pt = geom.getPointIn();
        UGraphic ugGoto = this.getUg().apply(gotoColor).apply(gotoColor.bg());
        ugGoto = ugGoto.apply(new UTranslate(pt));
        UTranslate posNow = this.getPosition();
        UTranslate dest = this.positions.get(ftile.getName());
        if (dest == null) {
            return;
        }
        double dx = dest.getDx() - posNow.getDx();
        double dy = dest.getDy() - posNow.getDy();
        ugGoto.draw(new UEllipse(3.0, 3.0));
        ugGoto.apply(new UTranslate(dx, dy)).draw(new UEllipse(3.0, 3.0));
        ugGoto.draw(ULine.hline(dx));
        ugGoto.apply(UTranslate.dx(dx)).draw(ULine.vline(dy));
    }

    @Override
    public UGraphic apply(UChange change) {
        return new UGraphicInterceptorUDrawable2(this.getUg().apply(change), this.positions);
    }
}

