/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.descdiagram.command.Labels;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;

public final class CommandLinkClass
extends SingleLineCommand2<AbstractClassOrObjectDiagram> {
    private static final String SINGLE = "[.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*";
    private static final String SINGLE_GUILLEMENT = "[%g][.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*[%g]";
    private static final String SINGLE2 = "(?:[.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*|[%g][.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*[%g])";
    private static final String COUPLE = "\\([%s]*((?:[.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*|[%g][.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*[%g]))[%s]*,[%s]*((?:[.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*|[%g][.\\\\]{0,2}[%pLN_]+(?:[.\\\\]{1,2}[%pLN_]+)*[%g]))[%s]*\\)";

    public CommandLinkClass(UmlDiagramType umlDiagramType) {
        super(CommandLinkClass.getRegexConcat(umlDiagramType));
    }

    private static RegexConcat getRegexConcat(UmlDiagramType umlDiagramType) {
        return RegexConcat.build(CommandLinkClass.class.getName() + (Object)((Object)umlDiagramType), RegexLeaf.start(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("HEADER", "@([\\d.]+)"), RegexLeaf.spaceOneOrMore())), new RegexOr(new RegexLeaf("ENT1", CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE1", COUPLE)), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("[\\[]"), new RegexLeaf("QUALIFIER1", "([^\\[\\]]+)"), new RegexLeaf("[\\]]"), RegexLeaf.spaceOneOrMore())), new RegexOptional((IRegex)new RegexLeaf("FIRST_LABEL", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexConcat(new RegexLeaf("ARROW_HEAD1", "((?<=[%s])+[ox]|[)#\\[<*+^}]|\\<_|\\<\\|[\\:\\|]|[<\\[]\\||\\}o|\\}\\||\\|o|\\|\\|)?"), new RegexLeaf("ARROW_BODY1", "([-=.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(left|right|up|down|le?|ri?|up?|do?)?"), new RegexOptional((IRegex)new RegexLeaf("INSIDE", "(0|\\(0\\)|\\(0|0\\))(?=[-=.~])")), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-=.]*)"), new RegexLeaf("ARROW_HEAD2", "([ox][%s]+|:\\>\\>?|_\\>|[(#\\]>*+^\\{]|[\\|\\:]\\|\\>|\\|[>\\]]|o\\{|\\|\\{|o\\||\\|\\|)?")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("SECOND_LABEL", "[%g]([^%g]+)[%g]")), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("[\\[]"), new RegexLeaf("QUALIFIER2", "([^\\[\\]]+)"), new RegexLeaf("[\\]]"), RegexLeaf.spaceOneOrMore())), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf("ENT2", CommandLinkClass.getClassIdentifier()), new RegexLeaf("COUPLE2", COUPLE)), RegexLeaf.spaceZeroOrMore(), CommandLinkClass.color().getRegex(), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("LABEL_LINK", "(.+)"))), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    private static String getClassIdentifier() {
        return "(" + CommandLinkClass.getSeparator() + "?[%pLN_$]+(?:" + CommandLinkClass.getSeparator() + "[%pLN_$]+)*|[%g][^%g]+[%g])";
    }

    public static String getSeparator() {
        return "(?:\\.|::|\\\\|\\\\\\\\)";
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractClassOrObjectDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        Direction dir;
        Entity cl2;
        String ent1String = diagram.cleanId(arg.get("ENT1", 0));
        String ent2String = diagram.cleanId(arg.get("ENT2", 0));
        if (ent1String == null && ent2String == null) {
            return this.executeArgSpecial3(diagram, arg);
        }
        if (ent1String == null) {
            return this.executeArgSpecial1(diagram, arg);
        }
        if (ent2String == null) {
            return this.executeArgSpecial2(diagram, arg);
        }
        String port1 = null;
        String port2 = null;
        LinkType linkType = this.getLinkType(arg);
        if (ent1String.contains("::") && diagram.firstWithName(ent1String) == null) {
            port1 = diagram.getPortId(ent1String);
            ent1String = diagram.removePortId(ent1String);
        }
        if (ent2String.contains("::") && diagram.firstWithName(ent2String) == null) {
            port2 = diagram.getPortId(ent2String);
            ent2String = diagram.removePortId(ent2String);
        }
        Quark<Entity> quark1 = diagram.quarkInContext(ent1String, false);
        Quark<Entity> quark2 = diagram.quarkInContext(ent2String, false);
        Entity cl1 = quark1.getData();
        if (cl1 == null) {
            cl1 = diagram.reallyCreateLeaf(quark1, Display.getWithNewlines(quark1.getName()), LeafType.CLASS, null);
        }
        if ((cl2 = quark2.getData()) == null) {
            cl2 = diagram.reallyCreateLeaf(quark2, Display.getWithNewlines(quark2.getName()), LeafType.CLASS, null);
        }
        int queue = (dir = this.getDirection(arg)) == Direction.LEFT || dir == Direction.RIGHT ? 1 : this.getQueueLength(arg);
        Labels labels = new Labels(arg);
        String kal1 = arg.get("QUALIFIER1", 0);
        String kal2 = arg.get("QUALIFIER2", 0);
        LinkArg linkArg = LinkArg.build(labels.getDisplay(), queue, diagram.getSkinParam().classAttributeIconSize() > 0).withQuantifier(labels.getFirstLabel(), labels.getSecondLabel()).withDistanceAngle(diagram.getLabeldistance(), diagram.getLabelangle()).withKal(kal1, kal2);
        Link link = new Link(diagram.getEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), cl1, cl2, linkType, linkArg);
        if (arg.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(arg.get("URL", 0));
            link.setUrl(url);
        }
        link.setPortMembers(port1, port2);
        if (dir == Direction.LEFT || dir == Direction.UP) {
            link = link.getInv();
        }
        link.setLinkArrow(labels.getLinkArrow());
        link.setColors(CommandLinkClass.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet()));
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        link.setCodeLine(location);
        this.addLink(diagram, link, arg.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private void addLink(AbstractClassOrObjectDiagram diagram, Link link, String weight) {
        diagram.addLink(link);
        if (weight != null) {
            link.setWeight(Double.parseDouble(weight));
        }
    }

    private CommandExecutionResult executePackageLink(AbstractClassOrObjectDiagram diagram, RegexResult arg) throws NoSuchColorException {
        String ent1String = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 0), "\"");
        String ent2String = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 0), "\"");
        Entity cl1 = diagram.getGroup(ent1String);
        Entity cl2 = diagram.getGroup(ent2String);
        LinkType linkType = this.getLinkType(arg);
        Direction dir = this.getDirection(arg);
        int queue = dir == Direction.LEFT || dir == Direction.RIGHT ? 1 : this.getQueueLength(arg);
        Display labelLink = Display.getWithNewlines(arg.get("LABEL_LINK", 0));
        String firstLabel = arg.get("FIRST_LABEL", 0);
        String secondLabel = arg.get("SECOND_LABEL", 0);
        LinkArg linkArg = LinkArg.build(labelLink, queue, diagram.getSkinParam().classAttributeIconSize() > 0);
        Link link = new Link(diagram.getEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), cl1, cl2, linkType, linkArg.withQuantifier(firstLabel, secondLabel).withDistanceAngle(diagram.getLabeldistance(), diagram.getLabelangle()));
        link.setColors(CommandLinkClass.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet()));
        diagram.resetPragmaLabel();
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        this.addLink(diagram, link, arg.get("HEADER", 0));
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial1(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Display label;
        LinkType linkType;
        boolean result;
        String name1A = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("COUPLE1", 0));
        String name1B = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("COUPLE1", 1));
        Quark<Entity> quark1A = diagram.quarkInContext(name1A, false);
        Quark<Entity> quark1B = diagram.quarkInContext(name1B, false);
        if (!(quark1A.getData() != null)) {
            return CommandExecutionResult.error("No class " + name1A);
        }
        if (!(quark1B.getData() != null)) {
            return CommandExecutionResult.error("No class " + name1B);
        }
        Entity cl1A = quark1A.getData();
        Entity cl1B = quark1B.getData();
        String id2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT2", 0), "\"");
        Quark<Entity> ent2 = diagram.quarkInContext(id2, false);
        Entity cl2 = ent2.getData();
        if (cl2 == null) {
            cl2 = diagram.reallyCreateLeaf(ent2, Display.getWithNewlines(ent2.getName()), LeafType.CLASS, null);
        }
        if (!(result = diagram.associationClass(1, cl1A, cl1B, cl2, linkType = this.getLinkType(arg), label = Display.getWithNewlines(arg.get("LABEL_LINK", 0))))) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial2(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        Display label;
        LinkType linkType;
        boolean result;
        String name2A = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("COUPLE2", 0));
        String name2B = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("COUPLE2", 1));
        Quark<Entity> quark2A = diagram.quarkInContext(name2A, false);
        Quark<Entity> quark2B = diagram.quarkInContext(name2B, false);
        if (!(quark2A.getData() != null)) {
            return CommandExecutionResult.error("No class " + name2A);
        }
        if (!(quark2B.getData() != null)) {
            return CommandExecutionResult.error("No class " + name2B);
        }
        Entity cl2A = quark2A.getData();
        Entity cl2B = quark2B.getData();
        String id1 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("ENT1", 0), "\"");
        Quark<Entity> ent1 = diagram.quarkInContext(id1, false);
        Entity cl1 = ent1.getData();
        if (cl1 == null) {
            cl1 = diagram.reallyCreateLeaf(ent1, Display.getWithNewlines(ent1.getName()), LeafType.CLASS, null);
        }
        if (!(result = diagram.associationClass(2, cl2A, cl2B, cl1, linkType = this.getLinkType(arg), label = Display.getWithNewlines(arg.get("LABEL_LINK", 0))))) {
            return CommandExecutionResult.error("Cannot have more than 2 assocications");
        }
        return CommandExecutionResult.ok();
    }

    private CommandExecutionResult executeArgSpecial3(AbstractClassOrObjectDiagram diagram, RegexResult arg) {
        String name1A = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("COUPLE1", 0));
        String name1B = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("COUPLE1", 1));
        String name2A = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("COUPLE2", 0));
        String name2B = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("COUPLE2", 1));
        Quark<Entity> quark1A = diagram.quarkInContext(name1A, false);
        Quark<Entity> quark1B = diagram.quarkInContext(name1B, false);
        Quark<Entity> quark2A = diagram.quarkInContext(name2A, false);
        Quark<Entity> quark2B = diagram.quarkInContext(name2B, false);
        if (!(quark1A.getData() != null)) {
            return CommandExecutionResult.error("No class " + name1A);
        }
        if (!(quark1B.getData() != null)) {
            return CommandExecutionResult.error("No class " + name1B);
        }
        if (!(quark2A.getData() != null)) {
            return CommandExecutionResult.error("No class " + name2A);
        }
        if (!(quark2B.getData() != null)) {
            return CommandExecutionResult.error("No class " + name2B);
        }
        Entity cl1A = quark1A.getData();
        Entity cl1B = quark1B.getData();
        Entity cl2A = quark2A.getData();
        Entity cl2B = quark2B.getData();
        LinkType linkType = this.getLinkType(arg);
        Display label = Display.getWithNewlines(arg.get("LABEL_LINK", 0));
        return diagram.associationClass(cl1A, cl1B, cl2A, cl2B, linkType, label);
    }

    private LinkDecor getDecors1(String s) {
        if (s == null) {
            return LinkDecor.NONE;
        }
        if ("<|".equals(s = StringUtils.trin(s))) {
            return LinkDecor.EXTENDS;
        }
        if ("<|:".equals(s)) {
            return LinkDecor.DEFINEDBY;
        }
        if ("<||".equals(s)) {
            return LinkDecor.REDEFINES;
        }
        if ("}".equals(s)) {
            return LinkDecor.CROWFOOT;
        }
        if ("}o".equals(s)) {
            return LinkDecor.CIRCLE_CROWFOOT;
        }
        if ("}|".equals(s)) {
            return LinkDecor.LINE_CROWFOOT;
        }
        if ("|o".equals(s)) {
            return LinkDecor.CIRCLE_LINE;
        }
        if ("||".equals(s)) {
            return LinkDecor.DOUBLE_LINE;
        }
        if ("<".equals(s)) {
            return LinkDecor.ARROW;
        }
        if ("^".equals(s)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(s)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(s)) {
            return LinkDecor.AGREGATION;
        }
        if ("x".equals(s)) {
            return LinkDecor.NOT_NAVIGABLE;
        }
        if ("*".equals(s)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(s)) {
            return LinkDecor.SQUARE;
        }
        if (")".equals(s)) {
            return LinkDecor.PARENTHESIS;
        }
        return LinkDecor.NONE;
    }

    private LinkDecor getDecors2(String s) {
        if (s == null) {
            return LinkDecor.NONE;
        }
        if ("|>".equals(s = StringUtils.trin(s))) {
            return LinkDecor.EXTENDS;
        }
        if (":|>".equals(s)) {
            return LinkDecor.DEFINEDBY;
        }
        if ("||>".equals(s)) {
            return LinkDecor.REDEFINES;
        }
        if (">".equals(s)) {
            return LinkDecor.ARROW;
        }
        if ("{".equals(s)) {
            return LinkDecor.CROWFOOT;
        }
        if ("o{".equals(s)) {
            return LinkDecor.CIRCLE_CROWFOOT;
        }
        if ("|{".equals(s)) {
            return LinkDecor.LINE_CROWFOOT;
        }
        if ("o|".equals(s)) {
            return LinkDecor.CIRCLE_LINE;
        }
        if ("||".equals(s)) {
            return LinkDecor.DOUBLE_LINE;
        }
        if ("^".equals(s)) {
            return LinkDecor.EXTENDS;
        }
        if ("+".equals(s)) {
            return LinkDecor.PLUS;
        }
        if ("o".equals(s)) {
            return LinkDecor.AGREGATION;
        }
        if ("x".equals(s)) {
            return LinkDecor.NOT_NAVIGABLE;
        }
        if ("*".equals(s)) {
            return LinkDecor.COMPOSITION;
        }
        if ("#".equals(s)) {
            return LinkDecor.SQUARE;
        }
        if ("(".equals(s)) {
            return LinkDecor.PARENTHESIS;
        }
        return LinkDecor.NONE;
    }

    private LinkType getLinkType(RegexResult arg) {
        String middle;
        LinkDecor decors1 = this.getDecors1(this.getArrowHead1(arg));
        LinkDecor decors2 = this.getDecors2(this.getArrowHead2(arg));
        LinkType result = new LinkType(decors2, decors1);
        if (arg.get("ARROW_BODY1", 0).contains(".") || arg.get("ARROW_BODY2", 0).contains(".")) {
            result = result.goDashed();
        }
        if ("0".equals(middle = arg.get("INSIDE", 0))) {
            result = result.withMiddleCircle();
        } else if ("0)".equals(middle)) {
            result = result.withMiddleCircleCircled1();
        } else if ("(0".equals(middle)) {
            result = result.withMiddleCircleCircled2();
        } else if ("(0)".equals(middle)) {
            result = result.withMiddleCircleCircled();
        }
        return result;
    }

    private int getQueueLength(RegexResult arg) {
        String s = this.getFullArrow(arg);
        s = s.replaceAll("[^-.=]", "");
        return s.length();
    }

    private Direction getDirection(RegexResult arg) {
        String s = this.getFullArrow(arg);
        if ((s = s.replaceAll("[^-.=\\w]", "")).startsWith("o")) {
            s = s.substring(1);
        }
        if (s.endsWith("o")) {
            s = s.substring(0, s.length() - 1);
        }
        Direction result = StringUtils.getQueueDirection(s);
        return result;
    }

    private String getArrowHead1(RegexResult arg) {
        return this.getArrowHead(arg, "ARROW_HEAD1");
    }

    private String getArrowHead2(RegexResult arg) {
        return this.getArrowHead(arg, "ARROW_HEAD2");
    }

    private String getArrowHead(RegexResult arg, String key) {
        return CommandLinkClass.notNull(arg.get(key, 0));
    }

    private String getFullArrow(RegexResult arg) {
        return this.getArrowHead1(arg) + CommandLinkClass.notNull(arg.get("ARROW_BODY1", 0)) + CommandLinkClass.notNull(arg.get("ARROW_DIRECTION", 0)) + CommandLinkClass.notNull(arg.get("ARROW_BODY2", 0)) + this.getArrowHead2(arg);
    }

    public static String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

