/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.txt;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import net.sourceforge.plantuml.asciiart.TextStringBounder;
import net.sourceforge.plantuml.asciiart.TranslatedCharArea;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.asciiart.UmlCharAreaImpl;
import net.sourceforge.plantuml.klimt.ClipContainer;
import net.sourceforge.plantuml.klimt.UShape;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import net.sourceforge.plantuml.klimt.font.FontStyle;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UImage;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.security.SecurityUtils;

public class UGraphicTxt
extends AbstractCommonUGraphic
implements ClipContainer {
    private final UmlCharArea charArea;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        return new UGraphicTxt(this);
    }

    private UGraphicTxt(UGraphicTxt other) {
        super(other);
        this.charArea = other.charArea;
    }

    public UGraphicTxt() {
        super(HColors.BLACK, ColorMapper.IDENTITY, new TextStringBounder());
        this.charArea = new UmlCharAreaImpl();
    }

    public void draw(UShape shape) {
        if (shape instanceof UText) {
            UText txt = (UText)shape;
            int y = (int)(this.getTranslateY() + txt.getDescent(this.getStringBounder())) / 10;
            if (txt.getFontConfiguration().containsStyle(FontStyle.WAVE)) {
                this.charArea.drawHLine('^', y, this.getDx(), txt.getText().length());
                this.charArea.drawStringLR(txt.getText(), this.getDx(), y + 1);
            } else {
                this.charArea.drawStringLR(txt.getText(), this.getDx(), y);
            }
            return;
        }
        if (shape instanceof UImage) {
            return;
        }
    }

    public final UmlCharArea getCharArea() {
        return new TranslatedCharArea(this.charArea, this.getDx(), this.getDy());
    }

    private int getDy() {
        return (int)this.getTranslateY();
    }

    private int getDx() {
        return (int)this.getTranslateX();
    }

    public XDimension2D getDimension() {
        return new XDimension2D(0.0, 0.0);
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        PrintStream ps = SecurityUtils.createPrintStream(os, true, StandardCharsets.UTF_8);
        this.getCharArea().print(ps);
    }
}

