/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UEllipse;

public class CircleInterface
implements UDrawable {
    private final float thickness;
    private final double headDiam;
    private final HColor backgroundColor;
    private final HColor foregroundColor;

    public CircleInterface(HColor backgroundColor, HColor foregroundColor, double headDiam, float thickness) {
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        this.headDiam = headDiam;
        this.thickness = thickness;
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse head = new UEllipse(this.headDiam, this.headDiam);
        ug.apply(new UStroke(this.thickness)).apply(this.backgroundColor.bg()).apply(this.foregroundColor).apply(new UTranslate(this.thickness, this.thickness)).draw(head);
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.headDiam + (double)(2.0f * this.thickness);
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.headDiam + (double)(2.0f * this.thickness);
    }
}

