/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.EntityPosition;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.dot.GraphvizVersion;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.skin.AlignmentParam;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterDotStringKermor;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.SvekLine;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.SvekUtils;

public class ClusterDotString {
    private final Cluster cluster;
    private final ISkinParam skinParam;
    private static final String ID_EE = "ee";

    public ClusterDotString(Cluster cluster, ISkinParam skinParam) {
        this.cluster = cluster;
        this.skinParam = skinParam;
    }

    void printInternal(StringBuilder sb, Collection<SvekLine> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        String label;
        Set<EntityPosition> entityPositionsExceptNormal;
        boolean thereALinkFromOrToGroup2;
        if (this.cluster.diagram.getPragma().useKermor()) {
            new ClusterDotStringKermor(this.cluster, this.skinParam).printInternal(sb, lines, stringBounder, dotMode, graphvizVersion, type);
            return;
        }
        boolean thereALinkFromOrToGroup1 = thereALinkFromOrToGroup2 = this.isThereALinkFromOrToGroup(lines);
        boolean useProtectionWhenThereALinkFromOrToGroup = graphvizVersion.useProtectionWhenThereALinkFromOrToGroup();
        if (!useProtectionWhenThereALinkFromOrToGroup) {
            thereALinkFromOrToGroup1 = false;
        }
        if (thereALinkFromOrToGroup1) {
            this.subgraphClusterNoLabel(sb, "a");
        }
        if ((entityPositionsExceptNormal = this.entityPositionsExceptNormal()).size() > 0) {
            for (SvekLine line : lines) {
                if (!line.isLinkFromOrTo(this.cluster.getGroup())) continue;
                line.setProjectionCluster(this.cluster);
            }
        }
        boolean protection0 = this.protection0(type);
        boolean protection1 = this.protection1(type);
        if (entityPositionsExceptNormal.size() > 0 || !useProtectionWhenThereALinkFromOrToGroup) {
            protection0 = false;
            protection1 = false;
        }
        if (protection0) {
            this.subgraphClusterNoLabel(sb, "p0");
        }
        sb.append("subgraph " + this.cluster.getClusterId() + " {");
        sb.append("style=solid;");
        sb.append("color=\"" + StringUtils.sharp000000(this.cluster.getColor()) + "\";");
        if (this.cluster.isLabel()) {
            StringBuilder sblabel = new StringBuilder("<");
            SvekLine.appendTable(sblabel, this.cluster.getTitleAndAttributeWidth(), this.cluster.getTitleAndAttributeHeight() - 5, this.cluster.getTitleColor());
            sblabel.append(">");
            label = sblabel.toString();
            HorizontalAlignment align = this.skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
            sb.append("labeljust=\"" + align.getGraphVizValue() + "\";");
        } else {
            label = "\"\"";
        }
        if (entityPositionsExceptNormal.size() > 0) {
            this.printRanks("source", this.withPosition(EntityPosition.getInputs()), sb, stringBounder);
            this.printRanks("sink", this.withPosition(EntityPosition.getOutputs()), sb, stringBounder);
            if (this.hasPort()) {
                this.subgraphClusterNoLabel(sb, ID_EE);
            } else {
                this.subgraphClusterWithLabel(sb, ID_EE, label);
            }
        } else {
            sb.append("label=" + label + ";");
            SvekUtils.println(sb);
        }
        if (thereALinkFromOrToGroup2) {
            sb.append(Cluster.getSpecialPointId(this.cluster.getGroup()) + " [shape=point,width=.01,label=\"\"];");
        }
        if (thereALinkFromOrToGroup1) {
            this.subgraphClusterNoLabel(sb, "i");
        }
        if (protection1) {
            this.subgraphClusterNoLabel(sb, "p1");
        }
        if (this.skinParam.useSwimlanes(type)) {
            sb.append("{rank = source; ");
            sb.append(this.getSourceInPoint(type));
            sb.append(" [shape=point,width=.01,label=\"\"];");
            sb.append(this.cluster.getMinPoint(type) + "->" + this.getSourceInPoint(type) + "  [weight=999];");
            sb.append("}");
            SvekUtils.println(sb);
            sb.append("{rank = sink; ");
            sb.append(this.getSinkInPoint(type));
            sb.append(" [shape=point,width=.01,label=\"\"];");
            sb.append("}");
            sb.append(this.getSinkInPoint(type) + "->" + this.cluster.getMaxPoint(type) + "  [weight=999];");
            SvekUtils.println(sb);
        }
        SvekUtils.println(sb);
        this.cluster.printCluster1(sb, lines, stringBounder);
        SvekNode added = this.cluster.printCluster2(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        if (entityPositionsExceptNormal.size() > 0) {
            if (this.hasPort()) {
                sb.append(this.empty() + " [shape=rect,width=.01,height=.01,label=");
                sb.append(label);
                sb.append("];");
            } else if (added == null) {
                sb.append(this.empty() + " [shape=point,width=.01,label=\"\"];");
            }
        }
        SvekUtils.println(sb);
        sb.append("}");
        if (protection1) {
            sb.append("}");
        }
        if (thereALinkFromOrToGroup1) {
            sb.append("}");
            sb.append("}");
        }
        if (entityPositionsExceptNormal.size() > 0) {
            sb.append("}");
        }
        if (protection0) {
            sb.append("}");
        }
        SvekUtils.println(sb);
    }

    private String getSourceInPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "sourceIn" + this.cluster.getColor();
        }
        return null;
    }

    private String getSinkInPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "sinkIn" + this.cluster.getColor();
        }
        return null;
    }

    private String empty() {
        return Cluster.getSpecialPointId(this.cluster.getGroup());
    }

    private boolean hasPort() {
        for (EntityPosition pos : this.entityPositionsExceptNormal()) {
            if (!pos.isPort()) continue;
            return true;
        }
        return false;
    }

    private Set<EntityPosition> entityPositionsExceptNormal() {
        EnumSet<EntityPosition> result = EnumSet.noneOf(EntityPosition.class);
        for (SvekNode sh : this.cluster.getNodes()) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) continue;
            result.add(sh.getEntityPosition());
        }
        return Collections.unmodifiableSet(result);
    }

    private void subgraphClusterNoLabel(StringBuilder sb, String id) {
        this.subgraphClusterWithLabel(sb, id, "\"\"");
    }

    private void subgraphClusterWithLabel(StringBuilder sb, String id, String label) {
        sb.append("subgraph " + this.cluster.getClusterId() + id + " {");
        sb.append("label=" + label + ";");
    }

    /*
     * WARNING - void declaration
     */
    private void printRanks(String rank, List<? extends SvekNode> entries, StringBuilder sb, StringBounder stringBounder) {
        if (entries.size() > 0) {
            sb.append("{rank=" + rank + ";");
            for (SvekNode svekNode : entries) {
                sb.append(svekNode.getUid() + ";");
            }
            sb.append("}");
            SvekUtils.println(sb);
            for (SvekNode svekNode : entries) {
                svekNode.appendShape(sb, stringBounder);
            }
            SvekUtils.println(sb);
            if (this.hasPort()) {
                void var6_11;
                boolean arrow = false;
                Object var6_10 = null;
                for (SvekNode svekNode : entries) {
                    if (arrow) {
                        sb.append("->");
                    }
                    arrow = true;
                    String string = svekNode.getUid();
                    sb.append(string);
                }
                if (arrow) {
                    sb.append(" [arrowhead=none]");
                }
                sb.append(';');
                SvekUtils.println(sb);
                sb.append((String)var6_11 + "->" + this.empty() + ";");
                SvekUtils.println(sb);
            }
        }
    }

    private List<SvekNode> withPosition(Set<EntityPosition> positions) {
        ArrayList<SvekNode> result = new ArrayList<SvekNode>();
        for (SvekNode sh : this.cluster.getNodes()) {
            if (!positions.contains((Object)sh.getEntityPosition())) continue;
            result.add(sh);
        }
        return result;
    }

    private boolean protection0(UmlDiagramType type) {
        return !this.skinParam.useSwimlanes(type);
    }

    private boolean protection1(UmlDiagramType type) {
        if (this.cluster.getGroup().getUSymbol() == USymbols.NODE) {
            return true;
        }
        return !this.skinParam.useSwimlanes(type);
    }

    private boolean isThereALinkFromOrToGroup(Collection<SvekLine> lines) {
        for (SvekLine line : lines) {
            if (!line.isLinkFromOrTo(this.cluster.getGroup())) continue;
            return true;
        }
        return false;
    }
}

