/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.extremity;

import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.geom.Side;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.svek.AbstractExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityFactory;
import net.sourceforge.plantuml.svek.extremity.ExtremityTriangle;

public class ExtremityFactoryTriangle
extends AbstractExtremityFactory
implements ExtremityFactory {
    private final HColor backgroundColor;
    private final int xWing;
    private final int yAperture;

    public ExtremityFactoryTriangle(HColor backgroundColor, int xWing, int yAperture) {
        this.backgroundColor = backgroundColor;
        this.xWing = xWing;
        this.yAperture = yAperture;
    }

    @Override
    public UDrawable createUDrawable(XPoint2D p0, double angle, Side side) {
        return new ExtremityTriangle(p0, angle - 1.5707963267948966, false, this.backgroundColor, this.xWing, this.yAperture);
    }

    @Override
    public UDrawable createUDrawable(XPoint2D p0, XPoint2D p1, XPoint2D p2, Side side) {
        double ortho = this.atan2(p0, p2);
        return new ExtremityTriangle(p1, ortho, true, this.backgroundColor, this.xWing, this.yAperture);
    }
}

