/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.filesdiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.filesdiagram.FilesType;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ISkinParam;

public class FilesEntry
implements Iterable<FilesEntry> {
    private final String name;
    private FilesType type;
    private List<FilesEntry> children = new ArrayList<FilesEntry>();

    public FilesEntry(String name, FilesType type) {
        this.name = name;
        this.type = type;
    }

    public FilesEntry addRawEntry(String raw) {
        int x = raw.indexOf(47);
        if (x == -1) {
            FilesEntry result = new FilesEntry(raw, FilesType.DATA);
            this.children.add(result);
            return result;
        }
        FilesEntry folder = this.getOrCreateFolder(raw.substring(0, x));
        String remain = raw.substring(x + 1);
        if (remain.length() == 0) {
            return folder;
        }
        return folder.addRawEntry(remain);
    }

    private FilesEntry getOrCreateFolder(String folderName) {
        for (FilesEntry child : this.children) {
            if (child.type != FilesType.FOLDER || !child.getName().equals(folderName)) continue;
            return child;
        }
        FilesEntry result = new FilesEntry(folderName, FilesType.FOLDER);
        this.children.add(result);
        return result;
    }

    @Override
    public Iterator<FilesEntry> iterator() {
        return Collections.unmodifiableCollection(this.children).iterator();
    }

    public String getName() {
        return this.name;
    }

    public String getEmoticon() {
        if (this.type == FilesType.FOLDER) {
            return "<:1f4c2:>";
        }
        return "<:1f4c4:>";
    }

    public UGraphic drawAndMove(UGraphic ug, FontConfiguration fontConfiguration, ISkinParam skinParam, double deltax) {
        Display display = Display.getWithNewlines(this.getEmoticon() + this.getName());
        TextBlock result = display.create(fontConfiguration, HorizontalAlignment.LEFT, skinParam);
        result.drawU(ug.apply(UTranslate.dx(deltax)));
        ug = ug.apply(UTranslate.dy(result.calculateDimension(ug.getStringBounder()).getHeight() + 2.0));
        for (FilesEntry child : this.children) {
            ug = child.drawAndMove(ug, fontConfiguration, skinParam, deltax + 21.0);
        }
        return ug;
    }
}

