/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.modifier.rule;

import apex.common.base.MoreStrings;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.rule.AnnotationContext;
import apex.jorje.semantic.ast.modifier.rule.AnnotationRule;
import apex.jorje.semantic.ast.modifier.rule.Element;
import apex.jorje.semantic.ast.modifier.rule.TypeContext;
import apex.jorje.semantic.compiler.sfdc.AccessEvaluator;
import apex.jorje.semantic.compiler.sfdc.PlaceholderOrgPerm;
import apex.jorje.semantic.symbol.type.ModifierOrAnnotationTypeInfo;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;
import com.google.common.collect.MoreSets;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;

public final class AnnotationRules {
    private AnnotationRules() {
    }

    public static AnnotationRule requiredModifiers(ModifierOrAnnotationTypeInfo ... modifiers) {
        return new RequiredModifiersRule(MoreSets.newLinkedHashSet(modifiers));
    }

    public static AnnotationRule disallowedModifiers(ModifierOrAnnotationTypeInfo ... modifiers) {
        return new DisallowedModifiersRule(MoreSets.newLinkedHashSet(modifiers));
    }

    public static AnnotationRule requiredAnyModifier(ModifierOrAnnotationTypeInfo ... modifiers) {
        return new RequiredAnyModifierRule(MoreSets.newLinkedHashSet(modifiers));
    }

    public static AnnotationRule redundantModifier(ModifierOrAnnotationTypeInfo ... modifiers) {
        return new RedundantModifierRule(MoreSets.newLinkedHashSet(modifiers));
    }

    public static AnnotationRule equivalentModifier(ModifierOrAnnotationTypeInfo ... modifiers) {
        return new EquivalentModifierRule(MoreSets.newLinkedHashSet(modifiers));
    }

    public static AnnotationRule elementSpecific(AnnotationRule rule, Element ... elements) {
        return new ElementSpecificRule(rule, MoreSets.newLinkedHashSet(elements));
    }

    public static AnnotationRule unitTypeSpecific(AnnotationRule rule, UnitType ... unitTypes) {
        return new UnitTypeSpecificRule(rule, MoreSets.newLinkedHashSet(unitTypes));
    }

    private static AnnotationRule versioned(AnnotationRule rule, Version minVersion, Version maxVersion) {
        return new VersionedRule(rule, minVersion, maxVersion);
    }

    public static AnnotationRule maxVersioned(AnnotationRule rule, Version maxVersion) {
        return AnnotationRules.versioned(rule, Version.MIN, maxVersion);
    }

    public static AnnotationRule minVersioned(AnnotationRule rule, Version minVersion) {
        return AnnotationRules.versioned(rule, minVersion, Version.MAX);
    }

    public static AnnotationRule minVersion(Version minVersion) {
        return new MinVersionRule(minVersion);
    }

    public static AnnotationRule definingType(AnnotationRule rule) {
        return new DefiningTypeRule(rule);
    }

    public static AnnotationRule definingTypeCondition(AnnotationRule rule, ModifierOrAnnotationTypeInfo modifier) {
        return new DefiningTypeConditionRule(rule, modifier);
    }

    public static AnnotationRule requiredDefiningType(UnitType ... unitTypes) {
        return new RequiredDefiningTypeRule(MoreSets.newLinkedHashSet(unitTypes));
    }

    public static AnnotationRule allowedElements(Element ... elements) {
        return new AllowedElementsRule(MoreSets.newLinkedHashSet(elements));
    }

    public static AnnotationRule internalVisible() {
        return new InternalVisibleRule();
    }

    public static AnnotationRule requiredTopLevel() {
        return new RequiredTopLevelRule();
    }

    public static AnnotationRule enclosingType(AnnotationRule rule) {
        return new EnclosingTypeRule(rule);
    }

    public static AnnotationRule enclosingUnitTypeSpecific(AnnotationRule rule, UnitType ... unitTypes) {
        return new EnclosingUnitTypeSpecificRule(rule, MoreSets.newLinkedHashSet(unitTypes));
    }

    public static AnnotationRule noNewProtectedMethod() {
        return NoNewProtectedMethodRule.get();
    }

    public static AnnotationRule gatedRule(AnnotationRule rule, Predicate<AccessEvaluator> gate) {
        return new GatedRule(rule, gate);
    }

    public static AnnotationRule permGuarded(PlaceholderOrgPerm orgPerm) {
        return new PermGuardedRule(orgPerm);
    }

    private static class PermGuardedRule
    implements AnnotationRule {
        private final PlaceholderOrgPerm orgPerm;

        private PermGuardedRule(PlaceholderOrgPerm orgPerm) {
            this.orgPerm = orgPerm;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (!context.getSymbols().getAccessEvaluator().hasPermission(this.orgPerm)) {
                context.addError(I18nSupport.getLabel("annotation.not.supported", name));
            }
        }
    }

    private static class MinVersionRule
    implements AnnotationRule {
        private final Version minVersion;

        private MinVersionRule(Version minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            Version current = context.getVersion();
            if (!current.isGreaterThanOrEqual(this.minVersion)) {
                context.addError(I18nSupport.getLabel("modifier.min.version", new Object[]{name, context.getElement(), this.minVersion.getExternal()}));
            }
        }
    }

    private static class VersionedRule
    implements AnnotationRule {
        private final Version minVersion;
        private final Version maxVersion;
        private final AnnotationRule rule;

        private VersionedRule(AnnotationRule rule, Version minVersion, Version maxVersion) {
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
            this.rule = rule;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (context.getVersion().isBetween(this.minVersion, this.maxVersion)) {
                this.rule.validate(context, modifiers, name);
            }
        }
    }

    private static class UnitTypeSpecificRule
    implements AnnotationRule {
        private final AnnotationRule rule;
        private final Set<UnitType> unitTypes;

        private UnitTypeSpecificRule(AnnotationRule rule, Set<UnitType> unitTypes) {
            this.unitTypes = unitTypes;
            this.rule = rule;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (context.getDefiningType() != null && this.unitTypes.contains((Object)context.getDefiningType().getUnitType())) {
                this.rule.validate(context, modifiers, name);
            }
        }
    }

    private static class InternalVisibleRule
    implements AnnotationRule {
        private InternalVisibleRule() {
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (!context.getDefiningType().getCodeUnitDetails().isTrusted()) {
                context.addError(I18nSupport.getLabel("modifier.is.internal", name));
            }
        }
    }

    private static class EquivalentModifierRule
    implements AnnotationRule {
        private final Set<ModifierOrAnnotationTypeInfo> modifiers;

        private EquivalentModifierRule(Set<ModifierOrAnnotationTypeInfo> modifiers) {
            this.modifiers = modifiers;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            for (ModifierOrAnnotationTypeInfo modifier : this.modifiers) {
                if (!modifiers.has(modifier)) continue;
                context.addError(I18nSupport.getLabel("modifier.is.by.default", name, modifier));
            }
        }
    }

    private static class ElementSpecificRule
    implements AnnotationRule {
        private final AnnotationRule rule;
        private final Set<Element> elements;

        private ElementSpecificRule(AnnotationRule rule, Set<Element> elements) {
            this.elements = elements;
            this.rule = rule;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (this.elements.contains((Object)context.getElement())) {
                this.rule.validate(context, modifiers, name);
            }
        }
    }

    private static class GatedRule
    implements AnnotationRule {
        private final AnnotationRule rule;
        private final Predicate<AccessEvaluator> gate;

        private GatedRule(AnnotationRule rule, Predicate<AccessEvaluator> gate) {
            this.rule = rule;
            this.gate = gate;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (!this.gate.test(context.getSymbols().getAccessEvaluator())) {
                this.rule.validate(context, modifiers, name);
            }
        }
    }

    private static class DisallowedModifiersRule
    implements AnnotationRule {
        private final Set<ModifierOrAnnotationTypeInfo> modifiers;

        private DisallowedModifiersRule(Set<ModifierOrAnnotationTypeInfo> modifiers) {
            this.modifiers = modifiers;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            for (ModifierOrAnnotationTypeInfo modifier : this.modifiers) {
                if (!modifiers.has(modifier)) continue;
                context.addError(I18nSupport.getLabel("modifier.cannot.be", new Object[]{name, context.getElement(), modifier}));
            }
        }
    }

    private static class DefiningTypeRule
    implements AnnotationRule {
        private final AnnotationRule rule;

        private DefiningTypeRule(AnnotationRule rule) {
            this.rule = rule;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (context.getDefiningType() != null) {
                this.rule.validate(context, context.getDefiningType().getModifiers(), I18nSupport.getLabel("modifier.illegal.defining.type.for", name));
            }
        }
    }

    private static class DefiningTypeConditionRule
    implements AnnotationRule {
        private final AnnotationRule rule;
        private final ModifierOrAnnotationTypeInfo modifier;

        private DefiningTypeConditionRule(AnnotationRule rule, ModifierOrAnnotationTypeInfo modifier) {
            this.rule = rule;
            this.modifier = modifier;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (context.getDefiningType() != null && context.getDefiningType().getModifiers().has(this.modifier)) {
                this.rule.validate(context, modifiers, I18nSupport.getLabel("defining.type.requires", this.modifier, name));
            }
        }
    }

    static class AllowedElementsRule
    implements AnnotationRule {
        private final Set<Element> elements;

        private AllowedElementsRule(Set<Element> elements) {
            assert (!elements.isEmpty()) : "illegal allowed elements rule";
            this.elements = elements;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (!this.elements.contains((Object)context.getElement())) {
                context.addError(I18nSupport.getLabel("modifier.is.not.allowed", new Object[]{name, context.getElement()}));
            }
        }
    }

    private static class RequiredAnyModifierRule
    implements AnnotationRule {
        private final Set<ModifierOrAnnotationTypeInfo> requiredModifiers;

        private RequiredAnyModifierRule(Set<ModifierOrAnnotationTypeInfo> requiredModifiers) {
            this.requiredModifiers = requiredModifiers;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (Collections.disjoint(modifiers.all(), this.requiredModifiers)) {
                context.addError(I18nSupport.getLabel("modifier.require.at.least", new Object[]{name, context.getElement(), this.requiredModifiers.stream().map(Object::toString).collect(MoreStrings.ON_COMMA_AND_SPACE)}));
            }
        }
    }

    private static class RedundantModifierRule
    implements AnnotationRule {
        private final Set<ModifierOrAnnotationTypeInfo> modifiers;

        private RedundantModifierRule(Set<ModifierOrAnnotationTypeInfo> modifiers) {
            this.modifiers = modifiers;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            for (ModifierOrAnnotationTypeInfo modifier : this.modifiers) {
                if (!modifiers.has(modifier)) continue;
                context.addError(I18nSupport.getLabel("modifier.is.by.default", new Object[]{context.getElement(), modifier}));
            }
        }
    }

    static class NoNewProtectedMethodRule
    implements AnnotationRule {
        private static final NoNewProtectedMethodRule INSTANCE = new NoNewProtectedMethodRule();

        private NoNewProtectedMethodRule() {
        }

        static NoNewProtectedMethodRule get() {
            return INSTANCE;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            assert (context.getElement() == Element.METHOD || context.getElement() == Element.CONSTRUCTOR) : "Protected is only valid for methods and constructors.";
            TypeInfo definingType = context.getDefiningType();
            if (definingType.getModifiers().none(ModifierTypeInfos.VIRTUAL, ModifierTypeInfos.ABSTRACT) && !TypeInfoUtil.isInnerTypeOfAnonymous(definingType) && !TypeInfoUtil.isInnerTypeOfTrigger(definingType) && !context.getModifiers().has(ModifierTypeInfos.OVERRIDE)) {
                context.addError(I18nSupport.getLabel("invalid.new.protected.method"));
            }
        }
    }

    private static class RequiredModifiersRule
    implements AnnotationRule {
        private final Set<ModifierOrAnnotationTypeInfo> requiredModifiers;

        private RequiredModifiersRule(Set<ModifierOrAnnotationTypeInfo> requiredModifiers) {
            this.requiredModifiers = requiredModifiers;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            for (ModifierOrAnnotationTypeInfo modifier : this.requiredModifiers) {
                if (!modifiers.not(modifier)) continue;
                context.addError(I18nSupport.getLabel("modifier.requires", new Object[]{name, context.getElement(), modifier}));
            }
        }
    }

    private static class RequiredDefiningTypeRule
    implements AnnotationRule {
        private final Set<UnitType> types;

        private RequiredDefiningTypeRule(Set<UnitType> types) {
            this.types = types;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (context.getDefiningType() != null && !this.types.contains((Object)context.getDefiningType().getUnitType())) {
                context.addError(I18nSupport.getLabel("modifier.illegal.defining.type", new Object[]{name, context.getDefiningType().getUnitType()}));
            }
        }
    }

    private static class EnclosingUnitTypeSpecificRule
    implements AnnotationRule {
        private final AnnotationRule rule;
        private final Set<UnitType> types;

        private EnclosingUnitTypeSpecificRule(AnnotationRule rule, Set<UnitType> types) {
            this.rule = rule;
            this.types = types;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (TypeInfoUtil.isInnerType(context.getDefiningType()) && this.types.contains((Object)context.getDefiningType().getEnclosingType().getUnitType())) {
                TypeContext enclosingContext = new TypeContext(context.getDefiningType().getEnclosingType(), context.getNode(), context.getScope());
                this.rule.validate(enclosingContext, context.getModifiers(), I18nSupport.getLabel("enclosing.type", this.types.stream().map(Object::toString).collect(MoreStrings.ON_COMMA)));
            }
        }
    }

    private static class EnclosingTypeRule
    implements AnnotationRule {
        private final AnnotationRule rule;

        private EnclosingTypeRule(AnnotationRule rule) {
            this.rule = rule;
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (TypeInfoUtil.isInnerType(context.getDefiningType())) {
                TypeContext outerContext = new TypeContext(context.getDefiningType().getEnclosingType(), context.getNode(), context.getScope());
                this.rule.validate(outerContext, ((AnnotationContext)outerContext).getModifiers(), I18nSupport.getLabel("enclosing.type.for", new Object[]{name, context.getElement()}));
            }
        }
    }

    private static class RequiredTopLevelRule
    implements AnnotationRule {
        private RequiredTopLevelRule() {
        }

        @Override
        public void validate(AnnotationContext context, ModifierGroup modifiers, String name) {
            if (context.getDefiningType() != null && !TypeInfoUtil.isTopLevel(context.getDefiningType())) {
                if (context.getElement().isType()) {
                    context.addError(I18nSupport.getLabel("modifier.not.on.top.level.type", name));
                } else {
                    context.addError(I18nSupport.getLabel("modifier.not.in.top.level.type", new Object[]{name, context.getElement()}));
                }
            }
        }
    }
}

