/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.EnumDecl;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.compilation.AdditionalInfo;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.CompilationUtil;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Field;
import apex.jorje.semantic.ast.member.FieldFactory;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.MethodFactory;
import apex.jorje.semantic.ast.member.Parameter;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.statement.SimpleStatement;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.ClassEmitMethods;
import apex.jorje.semantic.bcl.EnumEmitMethods;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.member.method.Generated;
import apex.jorje.semantic.symbol.member.method.StandardMethodInfo;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfoFactory;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.I18nSupport;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.objectweb.asm.ClassVisitor;

public class UserEnum
extends Compilation {
    public static final int MAX_NUM_ITEMS = 100;
    private static final ModifierGroup EXPLICIT_STATEMENT_EXECUTED_GLOBAL = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.GLOBAL).build();
    private static final ModifierGroup EXPLICIT_STATEMENT_EXECUTED_PRIVATE = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.PRIVATE).build();
    private static final ModifierGroup EXPLICIT_STATEMENT_EXECUTED_STATIC = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.STATIC).build();
    private static final ModifierGroup EXPLICIT_STATEMENT_EXECUTED_GLOBAL_OVERRIDE = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.GLOBAL, ModifierTypeInfos.OVERRIDE).build();
    private static final ModifierGroup EXPLICIT_STATEMENT_EXECUTED_PUBLIC_STATIC = ModifierGroup.builder().addModifiers(ModifierTypeInfos.EXPLICIT_STATEMENT_EXECUTED, ModifierTypeInfos.PUBLIC, ModifierTypeInfos.STATIC).build();
    private final Identifier name;
    private final TypeInfo enumType;
    private final ModifierGroup enumModifiers;
    private final List<Identifier> enums;
    private final List<Field> fields;
    private final List<Method> methods;
    private final AdditionalInfo additionalInfo;
    private final ModifierNode modifiers;

    public UserEnum(SourceFile source, AstNode definingNode, CompilationUnit.EnumDeclUnit compilationUnit) {
        EnumDecl body = compilationUnit.body;
        this.name = body.name;
        this.enumType = ((StandardTypeInfoImpl.Builder)StandardTypeInfoImpl.builder().setViaSource(source, AstNodes.getDefiningType(definingNode), compilationUnit)).build();
        this.enumModifiers = this.enumType.getModifiers().copy().addModifiers(ModifierTypeInfos.FINAL, ModifierTypeInfos.STATIC).build();
        this.enums = ImmutableList.copyOf(AstNodes.filterNotNull(body.members));
        this.fields = FieldFactory.createEnumFields(this, this.enumModifiers, this.enums);
        this.methods = ImmutableList.of(this.createClinit(), this.createInit(), this.createValues(), this.createValueOf(), this.createOrdinal(), this.createEquals(), this.createHashCode());
        this.additionalInfo = AdditionalInfo.builder().setDefiningNode(this).build();
        this.modifiers = new ModifierNode(this, this.enumType.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.modifiers.traverse(visitor, scope);
                for (Field field : this.fields) {
                    field.traverse(visitor, scope);
                }
                for (Method method : this.methods) {
                    method.traverse(visitor, scope);
                }
                this.additionalInfo.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            Errors errors = scope.getErrors();
            errors.addIfError(this, CompilationUtil.validateHasTopLevelModifiers(this));
            errors.addIfError((AstNode)this, this.name.getLoc(), IdentifierValidator.get().validate(this.enumType, this.name.getValue(), IdentifierValidator.Type.ENUM, TypeInfoUtil.isTopLevel(this.enumType), false));
            if (errors.isInvalid(this)) {
                return;
            }
            boolean isReservedNamespace = symbols.getAccessEvaluator().isReservedNamespace(this.enumType.getNamespace());
            if (this.fields.size() > 100 && !isReservedNamespace) {
                errors.markInvalid((AstNode)this, I18nSupport.getLabel("max.enums.exceeded", 100));
            }
            for (Field field : this.fields) {
                String name = field.getFieldInfo().getName();
                errors.addIfError((AstNode)this, field.getLoc(), IdentifierValidator.get().validate(this.enumType, name, IdentifierValidator.Type.VARIABLE, false, isReservedNamespace));
                field.validate(symbols, scope);
            }
            for (Method method : this.methods) {
                method.validate(symbols, scope);
            }
            this.additionalInfo.validate(symbols, scope);
            this.modifiers.validate(symbols, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Emitter emitter) {
        TypeStack.TypeContext clazz = TypeStack.TypeContext.builder().setType(this.enumType).build();
        emitter.getTypeStack().push(clazz);
        try {
            emitter.getAnnotationVisitor().set((ClassVisitor)clazz.getClassWriter());
            this.modifiers.emit(emitter);
            emitter.getAnnotationVisitor().unset();
            this.additionalInfo.emitAnnotation(emitter);
            for (Field field : this.fields) {
                field.emit(emitter);
            }
            for (Method method : this.methods) {
                method.emit(emitter);
            }
            this.additionalInfo.emit(emitter);
        }
        finally {
            byte[] bytes = CompilationUtil.getBytesOrAddTooLargeError(clazz.getClassWriter(), this, emitter.getCodeUnit().getErrors());
            emitter.getTypeStack().pop();
            this.setOutput(CompilationOutput.builder(this.enumType).setBytes(bytes).setLines(clazz.getKnownCodeLocations()).build());
        }
    }

    private Method createClinit() {
        SimpleStatement root = new SimpleStatement(this, SimpleStatement.Returnable.NO){

            @Override
            public void emit(Emitter emitter) {
                int i = 0;
                for (Identifier name : UserEnum.this.enums) {
                    emitter.emitType(Locations.NONE, 187, UserEnum.this.enumType.getBytecodeName());
                    emitter.emit(Locations.NONE, 89);
                    emitter.push(Locations.NONE, name.getValue());
                    emitter.push(Locations.NONE, i++);
                    emitter.emit(Locations.NONE, EnumEmitMethods.constructor(UserEnum.this.enumType));
                    emitter.emitField(Locations.NONE, 179, UserEnum.this.enumType.getBytecodeName(), name.getValue(), UserEnum.this.enumType.getTypeSignature());
                }
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(TypeInfos.VOID).setName("<clinit>").setModifiers(EXPLICIT_STATEMENT_EXECUTED_STATIC).setGenerated(Generated.ANONYMOUS), root);
    }

    private Method createInit() {
        SimpleStatement root = new SimpleStatement(this, SimpleStatement.Returnable.NO){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.emitVar(Locations.NONE, 25, 1);
                emitter.emitVar(Locations.NONE, 21, 2);
                emitter.emit(Locations.NONE, EnumEmitMethods.CONSTRUCTOR);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(TypeInfos.VOID).setName("<init>").setModifiers(EXPLICIT_STATEMENT_EXECUTED_PRIVATE).setGenerated(Generated.ANONYMOUS).setParameters(Parameter.builder().setName("str").setType(TypeInfos.STRING).setDefiningType(this.enumType).build(), Parameter.builder().setName("val").setType(InternalTypeInfos.PRIMITIVE_INTEGER).setDefiningType(this.enumType).build()), root);
    }

    private Method createValues() {
        final GenericTypeInfo list = GenericTypeInfoFactory.createList(this.enumType);
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitType(Locations.NONE, 187, list);
                emitter.emit(Locations.NONE, 89);
                emitter.emit(Locations.NONE, ObjectEmitMethods.constructor(list));
                for (Identifier name : UserEnum.this.enums) {
                    emitter.emit(Locations.NONE, 89);
                    emitter.emitField(Locations.NONE, 178, UserEnum.this.enumType.getBytecodeName(), name.getValue(), UserEnum.this.enumType.getTypeSignature());
                    emitter.emit(Locations.NONE, ListEmitMethods.addNoReturn(list));
                }
                emitter.emit(Locations.NONE, 89);
                emitter.emit(Locations.NONE, ListEmitMethods.readonly(list));
                emitter.emit(Locations.NONE, 176);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(list).setName("values").setModifiers(this.enumModifiers).setGenerated(Generated.ANONYMOUS), root);
    }

    private Method createValueOf() {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.push(Locations.NONE, UserEnum.this.enumType.getBytecodeName());
                emitter.emit(Locations.NONE, ClassEmitMethods.FOR_NAME);
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.emit(Locations.NONE, EnumEmitMethods.valueOf(UserEnum.this.enumType));
                emitter.emitType(Locations.NONE, 192, UserEnum.this.enumType);
                emitter.emit(Locations.NONE, 176);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(this.enumType).setName("valueOf").setModifiers(EXPLICIT_STATEMENT_EXECUTED_PUBLIC_STATIC).setGenerated(Generated.ANONYMOUS).setParameters(Parameter.builder().setName("str").setType(TypeInfos.STRING).setDefiningType(this.enumType).build()), root);
    }

    private Method createOrdinal() {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.emit(Locations.NONE, EnumEmitMethods.ORDINAL);
                emitter.box(TypeInfos.INTEGER);
                emitter.emit(Locations.NONE, 176);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(TypeInfos.INTEGER).setName("ordinal").setModifiers(EXPLICIT_STATEMENT_EXECUTED_GLOBAL_OVERRIDE).setGenerated(Generated.ANONYMOUS), root);
    }

    private Method createEquals() {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.emitVar(Locations.NONE, 25, 1);
                emitter.emit(Locations.NONE, ObjectEmitMethods.JAVA_EQUALS);
                emitter.box(TypeInfos.BOOLEAN);
                emitter.emit(Locations.NONE, 176);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(TypeInfos.BOOLEAN).setName("equals").setModifiers(EXPLICIT_STATEMENT_EXECUTED_GLOBAL).setGenerated(Generated.ANONYMOUS).setParameters(Parameter.builder().setName("obj").setType(TypeInfos.OBJECT).setDefiningType(this.enumType).build()), root);
    }

    private Method createHashCode() {
        SimpleStatement root = new SimpleStatement(this){

            @Override
            public void emit(Emitter emitter) {
                emitter.emitVar(Locations.NONE, 25, 0);
                emitter.emit(Locations.NONE, ObjectEmitMethods.JAVA_HASH_CODE);
                emitter.box(TypeInfos.INTEGER);
                emitter.emit(Locations.NONE, 176);
            }
        };
        return MethodFactory.create(this, StandardMethodInfo.builder().setDefiningType(this.enumType).setReturnType(TypeInfos.INTEGER).setName("hashCode").setModifiers(EXPLICIT_STATEMENT_EXECUTED_GLOBAL).setGenerated(Generated.ANONYMOUS), root);
    }

    @Override
    public Location getLoc() {
        return this.name.getLoc();
    }

    public ModifierNode getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("enumType", this.enumType).add("enums", this.enums).toString();
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.enumType;
    }
}

