/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.completions;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.impl.document.BadLocationException;
import apex.jorje.lsp.impl.utils.IndexUtil;
import apex.jorje.lsp.impl.utils.Locations;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.NewKeyValueObjectExpression;
import apex.jorje.semantic.ast.expression.NewObjectExpression;
import apex.jorje.semantic.ast.visitor.AdditionalPassScope;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.collect.ImmutableSet;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.Position;

public class SObjectCompletionActivationStrategy {
    private final ApexCompilerService compilerService;
    private final Document document;
    private final Position position;
    private ContextDeterminer contextDeterminer;

    @AssistedInject
    public SObjectCompletionActivationStrategy(ApexCompilerService compilerService, @Assisted Document document, @Assisted Position position) {
        this.compilerService = compilerService;
        this.document = document;
        this.position = position;
    }

    public void analyze() throws BadLocationException {
        this.contextDeterminer = new ContextDeterminer(this.document, Locations.getOffset(this.document, this.position));
        this.compilerService.compile(this.document, this.contextDeterminer);
    }

    public Optional<TypeInfo> getType() {
        assert (this.contextDeterminer != null) : "Call analyze() to begin analysis first";
        return this.contextDeterminer != null ? this.contextDeterminer.getTypeInfo() : Optional.empty();
    }

    public Set<String> getUsedParams() {
        return this.contextDeterminer.getUsedParams();
    }

    static final class ContextDeterminer
    extends AstVisitor<AdditionalPassScope> {
        private final Document document;
        private final int activationOffset;
        private TypeInfo typeInfo;
        private Set<String> usedParams;

        ContextDeterminer(Document document, int activationOffset) {
            this.document = document;
            this.activationOffset = activationOffset;
            this.usedParams = ImmutableSet.of();
        }

        Optional<TypeInfo> getTypeInfo() {
            return Optional.ofNullable(this.typeInfo);
        }

        Set<String> getUsedParams() {
            return this.usedParams;
        }

        @Override
        protected boolean defaultVisit() {
            return true;
        }

        @Override
        public void visitEnd(NewObjectExpression node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            if (this.isConstructor(node)) {
                this.typeInfo = node.getType();
            }
        }

        @Override
        public void visitEnd(NewKeyValueObjectExpression node, AdditionalPassScope scope) {
            super.visitEnd(node, scope);
            if (this.isConstructor(node)) {
                this.typeInfo = node.getType();
                this.usedParams = node.getParameters().stream().map(p -> p.getSObjectField().getName()).collect(Collectors.toSet());
            }
        }

        private boolean isConstructor(Expression node) {
            int endIndex;
            String source = this.document.getSource();
            int startIndex = source.indexOf("(", node.getLoc().getEndIndex()) + 1;
            if (startIndex == (endIndex = IndexUtil.computeEndOffset(source, node) - 1)) {
                return this.activationOffset == startIndex;
            }
            return this.activationOffset >= startIndex && endIndex >= this.activationOffset;
        }
    }
}

