/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.PostfixOp;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.bcl.DecimalEmitMethods;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;

public class PostfixExpression
extends Expression {
    private final PostfixOp op;
    private final Location loc;
    private final Expression expression;
    private final Expression store;

    public PostfixExpression(AstNode definingNode, Expr.PostfixExpr expr) {
        super(definingNode);
        this.op = expr.op;
        this.loc = Locations.from(expr);
        this.expression = AstNodes.get().create((AstNode)this, expr.expr);
        this.store = AstNodes.get().createStore(this, expr.expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.expression)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.store.validate(symbols, scope);
        if (scope.getErrors().isInvalid(this.store)) {
            scope.getErrors().markInvalid(this);
            return;
        }
        this.setType(this.expression.getType());
        if (!this.getType().getBasicType().isNumber()) {
            scope.getErrors().markInvalid((AstNode)this, I18nSupport.getLabel("invalid.numeric.postfix.operand", this.getType()));
        }
    }

    @Override
    public void emit(Emitter emitter) {
        this.expression.emit(emitter);
        block0 : switch (this.op) {
            case INC: {
                switch (this.getType().getBasicType()) {
                    case DECIMAL: {
                        this.swap(this.loc, emitter);
                        emitter.emit(this.loc, 4);
                        emitter.box(TypeInfos.INTEGER);
                        TypeConversion.emit(this.loc, emitter, TypeInfos.INTEGER, this.getType());
                        emitter.emit(this.loc, DecimalEmitMethods.ADD);
                        break block0;
                    }
                    case DOUBLE: {
                        this.swap(this.loc, emitter);
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 15);
                        emitter.emit(this.loc, 99);
                        emitter.box(this.getType());
                        break block0;
                    }
                    case LONG: {
                        this.swap(this.loc, emitter);
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 10);
                        emitter.emit(this.loc, 97);
                        emitter.box(this.getType());
                        break block0;
                    }
                    case INTEGER: {
                        this.swap(this.loc, emitter);
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 4);
                        emitter.emit(this.loc, 96);
                        emitter.box(this.getType());
                        break block0;
                    }
                }
                throw new UnexpectedCodePathException();
            }
            case DEC: {
                switch (this.getType().getBasicType()) {
                    case DECIMAL: {
                        this.swap(this.loc, emitter);
                        emitter.emit(this.loc, 4);
                        emitter.box(TypeInfos.INTEGER);
                        TypeConversion.emit(this.loc, emitter, TypeInfos.INTEGER, this.getType());
                        emitter.emit(this.loc, DecimalEmitMethods.SUBTRACT);
                        break block0;
                    }
                    case DOUBLE: {
                        this.swap(this.loc, emitter);
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 15);
                        emitter.emit(this.loc, 103);
                        emitter.box(this.getType());
                        break block0;
                    }
                    case LONG: {
                        this.swap(this.loc, emitter);
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 10);
                        emitter.emit(this.loc, 101);
                        emitter.box(this.getType());
                        break block0;
                    }
                    case INTEGER: {
                        this.swap(this.loc, emitter);
                        emitter.unbox(this.getType());
                        emitter.emit(this.loc, 4);
                        emitter.emit(this.loc, 100);
                        emitter.box(this.getType());
                        break block0;
                    }
                }
                throw new UnexpectedCodePathException();
            }
        }
        this.store.emit(emitter);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public PostfixOp getOp() {
        return this.op;
    }

    private void swap(Location loc, Emitter emitter) {
        if (!this.isTopLevel()) {
            emitter.emit(loc, 89);
            emitter.emit(loc, 95);
        }
    }
}

