/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumBody;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class AvoidFieldNameMatchingMethodNameRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTClassOrInterfaceBody node, Object data) {
        this.handleClassOrEnum(node, data);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTEnumBody node, Object data) {
        this.handleClassOrEnum(node, data);
        return super.visit(node, data);
    }

    private void handleClassOrEnum(JavaNode node, Object data) {
        int n = node.getNumChildren();
        ArrayList<ASTFieldDeclaration> fields = new ArrayList<ASTFieldDeclaration>();
        HashSet<String> methodNames = new HashSet<String>();
        for (int i = 0; i < n; ++i) {
            JavaNode child = node.getChild(i);
            if (child.getNumChildren() == 0) continue;
            if ((child = child.getChild(child.getNumChildren() - 1)) instanceof ASTFieldDeclaration) {
                fields.add((ASTFieldDeclaration)child);
                continue;
            }
            if (!(child instanceof ASTMethodDeclaration)) continue;
            methodNames.add(((ASTMethodDeclaration)child).getName().toLowerCase(Locale.ROOT));
        }
        for (ASTFieldDeclaration field : fields) {
            String varName = field.getVariableName().toLowerCase(Locale.ROOT);
            if (!methodNames.contains(varName)) continue;
            this.addViolation(data, field, field.getVariableName());
        }
    }
}

