/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.jorje.semantic.ast.expression.ArrayExpression;
import apex.jorje.semantic.ast.expression.ArrayLoadExpression;
import apex.jorje.semantic.ast.expression.ArrayStoreExpression;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NestedExpression;
import apex.jorje.semantic.ast.expression.ReferenceExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.visitor.DefaultAstVisitor;
import apex.jorje.semantic.ast.visitor.ValueScope;

public class GetOutermostExpressionVisitor
extends DefaultAstVisitor<ValueScope<Expression>> {
    private static final GetOutermostExpressionVisitor VISITOR_WITHOUT_NESTED_EXPRESSIONS = new GetOutermostExpressionVisitor(false);
    private static final GetOutermostExpressionVisitor VISITOR_WITH_NESTED_EXPRESSIONS = new GetOutermostExpressionVisitor(true);
    private final boolean continueOnNestedExpressions;

    public static GetOutermostExpressionVisitor getWithoutNestedExpressions() {
        return VISITOR_WITHOUT_NESTED_EXPRESSIONS;
    }

    public static GetOutermostExpressionVisitor getWithNestedExpressions() {
        return VISITOR_WITH_NESTED_EXPRESSIONS;
    }

    private GetOutermostExpressionVisitor(boolean continueOnNestedExpressions) {
        this.continueOnNestedExpressions = continueOnNestedExpressions;
    }

    @Override
    public void visitEnd(ReferenceExpression node, ValueScope<Expression> scope) {
        node.getDefiningNode().traverse(this, scope);
    }

    @Override
    public void visitEnd(MethodCallExpression node, ValueScope<Expression> scope) {
        if (scope.getValue() == null) {
            this.saveNodeAndTraverseUpwards(node, scope);
        } else if (node.getReferenceContext().getDottedExpression() == scope.getValue()) {
            this.saveNodeAndTraverseUpwards(node, scope);
        }
    }

    @Override
    public void visitEnd(VariableExpression node, ValueScope<Expression> scope) {
        this.saveNodeAndTraverseUpwards(node, scope);
    }

    @Override
    public void visitEnd(ArrayLoadExpression node, ValueScope<Expression> scope) {
        this.handleArrayExpression(node, scope);
    }

    @Override
    public void visitEnd(ArrayStoreExpression node, ValueScope<Expression> scope) {
        this.handleArrayExpression(node, scope);
    }

    private void handleArrayExpression(ArrayExpression node, ValueScope<Expression> scope) {
        if (node.getInnerExpression() == scope.getValue()) {
            this.saveNodeAndTraverseUpwards(node, scope);
        }
    }

    @Override
    public void visitEnd(NestedExpression node, ValueScope<Expression> scope) {
        if (this.continueOnNestedExpressions) {
            node.getDefiningNode().traverse(this, scope);
        }
    }

    private void saveNodeAndTraverseUpwards(Expression node, ValueScope<Expression> scope) {
        scope.setValue(node);
        node.getDefiningNode().traverse(this, scope);
    }
}

