/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.jaxen.DocumentNavigator;
import net.sourceforge.pmd.jaxen.MatchesFunction;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;
import org.jaxen.SimpleVariableContext;
import org.jaxen.XPath;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class DynamicXPathRule
extends AbstractRule
implements Opcodes {
    private static HashMap classes = new HashMap();
    private XPath xpath;
    private boolean regexpFunctionRegistered;

    protected DynamicXPathRule() {
    }

    public static synchronized Class loadClass(ClassLoader classloader, String type) {
        Class c = (Class)classes.get(type);
        if (c == null) {
            byte[] bytecode = DynamicXPathRule.buildClass(type);
            c = new ByteArrayClassLoader(classloader).loadClass(bytecode);
            classes.put(type, c);
        }
        return c;
    }

    private static byte[] buildClass(String type) {
        String className = "net/sourceforge/pmd/rules/" + type + "XPathRule";
        String methodSig = "(Lnet/sourceforge/pmd/ast/AST" + type + ";Ljava/lang/Object;)Ljava/lang/Object;";
        ClassWriter cw = new ClassWriter(0);
        cw.visit(48, 33, className, null, "net/sourceforge/pmd/rules/DynamicXPathRule", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "net/sourceforge/pmd/rules/DynamicXPathRule", "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "visit", methodSig, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, className, "evaluate", "(Lnet/sourceforge/pmd/ast/Node;Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(183, "net/sourceforge/pmd/rules/DynamicXPathRule", "visit", methodSig);
        mv.visitInsn(176);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    public void evaluate(Node compilationUnit, Object data) {
        try {
            this.initializeXPathExpression();
            List results = this.xpath.selectNodes(compilationUnit);
            Iterator i = results.iterator();
            while (i.hasNext()) {
                SimpleNode n = (SimpleNode)i.next();
                if (n instanceof ASTVariableDeclaratorId && this.getBooleanProperty("pluginname")) {
                    this.addViolation(data, n, n.getImage());
                    continue;
                }
                this.addViolation(data, n, this.getMessage());
            }
        }
        catch (JaxenException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initializeXPathExpression() throws JaxenException {
        if (this.xpath != null) {
            return;
        }
        if (!this.regexpFunctionRegistered) {
            MatchesFunction.registerSelfInSimpleContext();
            this.regexpFunctionRegistered = true;
        }
        String prop = this.getStringProperty("xpath");
        String tail = prop.trim().replaceFirst("^//\\w+", "");
        String subquery = '.' + tail.trim();
        this.xpath = new BaseXPath(subquery, new DocumentNavigator());
        if (this.properties.size() > 1) {
            SimpleVariableContext vc = new SimpleVariableContext();
            Iterator<Map.Entry<Object, Object>> i = this.properties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Object, Object> e = i.next();
                if ("xpath".equals(e.getKey())) continue;
                vc.setVariableValue((String)e.getKey(), e.getValue());
            }
            this.xpath.setVariableContext(vc);
        }
    }

    private static class ByteArrayClassLoader
    extends ClassLoader {
        ByteArrayClassLoader(ClassLoader parent) {
            super(parent);
        }

        Class loadClass(byte[] data) {
            return this.defineClass(null, data, 0, data.length, null);
        }
    }
}

