/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.sunsecure;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTExpression;
import net.sourceforge.pmd.ast.ASTFormalParameter;
import net.sourceforge.pmd.ast.ASTFormalParameters;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.ast.AccessNode;
import net.sourceforge.pmd.rules.sunsecure.AbstractSunSecureRule;

public class ArrayIsStoredDirectly
extends AbstractSunSecureRule {
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTAssignmentOperator;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTStatementExpression;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTPrimarySuffix;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTMethodDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTConstructorDeclaration;
    static /* synthetic */ Class class$net$sourceforge$pmd$ast$ASTEqualityExpression;

    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        ASTFormalParameter[] arrs = this.getArrays(node.getParameters());
        if (arrs != null) {
            List bs = node.findChildrenOfType(ASTBlockStatement.class);
            this.checkAll(data, arrs, bs);
        }
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        ASTFormalParameters params = (ASTFormalParameters)node.getFirstChildOfType(ASTFormalParameters.class);
        ASTFormalParameter[] arrs = this.getArrays(params);
        if (arrs != null) {
            this.checkAll(data, arrs, node.findChildrenOfType(ASTBlockStatement.class));
        }
        return data;
    }

    private void checkAll(Object context, ASTFormalParameter[] arrs, List bs) {
        for (int i = 0; i < arrs.length; ++i) {
            this.checkForDirectAssignment(context, arrs[i], bs);
        }
    }

    private boolean checkForDirectAssignment(Object ctx, ASTFormalParameter parameter, List bs) {
        ASTVariableDeclaratorId vid = (ASTVariableDeclaratorId)parameter.getFirstChildOfType(ASTVariableDeclaratorId.class);
        String varName = vid.getImage();
        Iterator it = bs.iterator();
        while (it.hasNext()) {
            ASTPrimarySuffix foo;
            ASTExpression e;
            AccessNode n;
            ASTStatementExpression se;
            ASTBlockStatement b = (ASTBlockStatement)it.next();
            if (!b.containsChildOfType(class$net$sourceforge$pmd$ast$ASTAssignmentOperator == null ? ArrayIsStoredDirectly.class$("net.sourceforge.pmd.ast.ASTAssignmentOperator") : class$net$sourceforge$pmd$ast$ASTAssignmentOperator) || (se = (ASTStatementExpression)b.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTStatementExpression == null ? ArrayIsStoredDirectly.class$("net.sourceforge.pmd.ast.ASTStatementExpression") : class$net$sourceforge$pmd$ast$ASTStatementExpression)) == null || !(se.jjtGetChild(0) instanceof ASTPrimaryExpression)) continue;
            ASTPrimaryExpression pe = (ASTPrimaryExpression)se.jjtGetChild(0);
            String assignedVar = this.getFirstNameImage(pe);
            if (assignedVar == null) {
                ASTPrimarySuffix suffix = (ASTPrimarySuffix)se.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTPrimarySuffix == null ? ArrayIsStoredDirectly.class$("net.sourceforge.pmd.ast.ASTPrimarySuffix") : class$net$sourceforge$pmd$ast$ASTPrimarySuffix);
                if (suffix == null) continue;
                assignedVar = suffix.getImage();
            }
            if ((n = (ASTMethodDeclaration)pe.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? ArrayIsStoredDirectly.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration") : class$net$sourceforge$pmd$ast$ASTMethodDeclaration)) == null && (n = (ASTConstructorDeclaration)pe.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTConstructorDeclaration == null ? ArrayIsStoredDirectly.class$("net.sourceforge.pmd.ast.ASTConstructorDeclaration") : class$net$sourceforge$pmd$ast$ASTConstructorDeclaration)) == null || this.isLocalVariable(assignedVar, n) || se.jjtGetNumChildren() < 3 || (e = (ASTExpression)se.jjtGetChild(2)).findChildrenOfType(class$net$sourceforge$pmd$ast$ASTEqualityExpression == null ? ArrayIsStoredDirectly.class$("net.sourceforge.pmd.ast.ASTEqualityExpression") : class$net$sourceforge$pmd$ast$ASTEqualityExpression).size() > 0) continue;
            String val = this.getFirstNameImage(e);
            if (val == null) {
                foo = (ASTPrimarySuffix)se.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTPrimarySuffix == null ? ArrayIsStoredDirectly.class$("net.sourceforge.pmd.ast.ASTPrimarySuffix") : class$net$sourceforge$pmd$ast$ASTPrimarySuffix);
                if (foo == null) continue;
                val = foo.getImage();
            }
            if (val == null || (foo = (ASTPrimarySuffix)se.getFirstChildOfType(class$net$sourceforge$pmd$ast$ASTPrimarySuffix == null ? ArrayIsStoredDirectly.class$("net.sourceforge.pmd.ast.ASTPrimarySuffix") : class$net$sourceforge$pmd$ast$ASTPrimarySuffix)) != null && foo.isArrayDereference() || !val.equals(varName)) continue;
            AccessNode md = (ASTMethodDeclaration)parameter.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTMethodDeclaration == null ? ArrayIsStoredDirectly.class$("net.sourceforge.pmd.ast.ASTMethodDeclaration") : class$net$sourceforge$pmd$ast$ASTMethodDeclaration);
            if (md == null) {
                md = (ASTConstructorDeclaration)pe.getFirstParentOfType(class$net$sourceforge$pmd$ast$ASTConstructorDeclaration == null ? ArrayIsStoredDirectly.class$("net.sourceforge.pmd.ast.ASTConstructorDeclaration") : class$net$sourceforge$pmd$ast$ASTConstructorDeclaration);
            }
            if (this.isLocalVariable(varName, md)) continue;
            this.addViolation(ctx, parameter, varName);
        }
        return false;
    }

    private final ASTFormalParameter[] getArrays(ASTFormalParameters params) {
        List l = params.findChildrenOfType(ASTFormalParameter.class);
        if (l != null && !l.isEmpty()) {
            Vector<ASTFormalParameter> v = new Vector<ASTFormalParameter>();
            Iterator it = l.iterator();
            while (it.hasNext()) {
                ASTFormalParameter fp = (ASTFormalParameter)it.next();
                if (!fp.isArray()) continue;
                v.add(fp);
            }
            return v.toArray(new ASTFormalParameter[v.size()]);
        }
        return null;
    }
}

