/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.status;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.status.Status;
import org.apache.ivy.util.Message;

public final class StatusManager {
    private List status = new ArrayList();
    private String defaultStatus;
    private Map statusPriorityMap;
    private Map statusIntegrationMap;

    public static StatusManager getCurrent() {
        return IvyContext.getContext().getSettings().getStatusManager();
    }

    public StatusManager(Status[] statusArray, String string) {
        this.status.addAll(Arrays.asList(statusArray));
        this.defaultStatus = string;
        this.computeMaps();
    }

    public StatusManager() {
    }

    public final void setDefaultStatus(String string) {
        this.defaultStatus = string;
    }

    public final List getStatuses() {
        return this.status;
    }

    private void computeMaps() {
        Status status;
        if (this.status.isEmpty()) {
            throw new IllegalStateException("badly configured statuses: no status found");
        }
        this.statusPriorityMap = new HashMap();
        Iterator iterator2 = this.status.listIterator();
        while (iterator2.hasNext()) {
            status = (Status)iterator2.next();
            this.statusPriorityMap.put(status.getName(), new Integer(iterator2.previousIndex()));
        }
        this.statusIntegrationMap = new HashMap();
        iterator2 = this.status.iterator();
        while (iterator2.hasNext()) {
            status = (Status)iterator2.next();
            this.statusIntegrationMap.put(status.getName(), status.isIntegration());
        }
    }

    public final boolean isStatus(String string) {
        if (this.statusPriorityMap == null) {
            this.computeMaps();
        }
        return this.statusPriorityMap.containsKey(string);
    }

    public final int getPriority(String string) {
        Integer n;
        if (this.statusPriorityMap == null) {
            this.computeMaps();
        }
        if ((n = (Integer)this.statusPriorityMap.get(string)) == null) {
            Message.debug("unknown status " + string + ": assuming lowest priority");
            return Integer.MAX_VALUE;
        }
        return n;
    }

    public final String getDefaultStatus() {
        if (this.defaultStatus == null) {
            if (this.status.isEmpty()) {
                throw new IllegalStateException("badly configured statuses: no status found");
            }
            this.defaultStatus = ((Status)this.status.get(this.status.size() - 1)).getName();
        }
        return this.defaultStatus;
    }
}

