/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.attributes.compiler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class AttributeIndexer
extends Task {
    private File jarFile;
    private List classes = new ArrayList();
    private Path classPath;
    private File baseName;
    private boolean inMaven = false;
    private static final String INDEX_FILENAME = "META-INF/attrs.index";
    private static final String SUFFIX = "$__attributeRepository.class";

    public void setJarfile(File jarFile) {
        this.jarFile = jarFile;
    }

    public void setBaseName(File baseName) {
        this.inMaven = true;
        this.baseName = baseName;
    }

    public Path createClasspath() {
        this.classPath = new Path(this.project);
        return this.classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyEntry(JarFile jar, JarEntry entry, JarOutputStream outputStream) throws Exception {
        outputStream.putNextEntry(entry);
        if (!entry.isDirectory()) {
            BufferedInputStream is = new BufferedInputStream(jar.getInputStream(entry));
            try {
                int numRead;
                byte[] buffer = new byte[16384];
                while ((numRead = ((InputStream)is).read(buffer, 0, 16384)) != 0) {
                    if (numRead == -1) {
                        break;
                    }
                    outputStream.write(buffer, 0, numRead);
                }
            }
            finally {
                ((InputStream)is).close();
            }
        }
    }

    protected void findJarFile() throws BuildException {
        File[] allFiles = this.baseName.getParentFile().listFiles();
        if (allFiles == null) {
            throw new BuildException("Unable to find any file with base name " + this.baseName.getName() + " in " + this.baseName.getParentFile().getPath());
        }
        long newestDate = 0L;
        for (int i = 0; i < allFiles.length; ++i) {
            String name = allFiles[i].getName();
            if (!name.startsWith(this.baseName.getName()) || !name.endsWith(".jar") || allFiles[i].lastModified() <= newestDate) continue;
            this.jarFile = allFiles[i];
            newestDate = allFiles[i].lastModified();
        }
        if (this.jarFile == null) {
            throw new BuildException("Unable to find any file with base name " + this.baseName.getName() + " in " + this.baseName.getParentFile().getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.inMaven) {
            this.findJarFile();
        }
        if (!this.jarFile.exists()) {
            this.log("Can't find " + this.jarFile.getPath());
            return;
        }
        try {
            this.log("Creating attribute index for " + this.jarFile.getPath());
            JarFile jar = new JarFile(this.jarFile);
            File newJarFile = new File(this.jarFile.getPath() + ".new");
            JarOutputStream output = new JarOutputStream(new FileOutputStream(newJarFile));
            try {
                String className;
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    if (!entry.isDirectory() && (className = entry.getName()).endsWith(SUFFIX)) {
                        className = className.replace('/', '.').replace('\\', '.').substring(0, className.length() - SUFFIX.length());
                        this.classes.add(className);
                    }
                    if (entry.getName().equals(INDEX_FILENAME)) continue;
                    this.copyEntry(jar, entry, output);
                }
                output.putNextEntry(new JarEntry(INDEX_FILENAME));
                Iterator attrs = this.classes.iterator();
                while (attrs.hasNext()) {
                    className = (String)attrs.next();
                    output.write(("Class: " + className + "\n").getBytes());
                }
            }
            finally {
                output.close();
                jar.close();
            }
            this.jarFile.delete();
            newJarFile.renameTo(this.jarFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.toString());
        }
    }
}

