/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.exps;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.kernel.exps.AbstractExpressionVisitor;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;

public class QueryExpressions
implements Serializable {
    public static final int DISTINCT_AUTO = 2;
    public static final int DISTINCT_TRUE = 4;
    public static final int DISTINCT_FALSE = 8;
    public static final Value[] EMPTY_VALUES = new Value[0];
    public Map updates = Collections.EMPTY_MAP;
    public int distinct = 2;
    public String alias = null;
    public Value[] projections = EMPTY_VALUES;
    public String[] projectionClauses = StoreQuery.EMPTY_STRINGS;
    public String[] projectionAliases = StoreQuery.EMPTY_STRINGS;
    public Class resultClass = null;
    public Expression filter = null;
    public Value[] grouping = EMPTY_VALUES;
    public String[] groupingClauses = StoreQuery.EMPTY_STRINGS;
    public Expression having = null;
    public Value[] ordering = EMPTY_VALUES;
    public boolean[] ascending = StoreQuery.EMPTY_BOOLEANS;
    public String[] orderingClauses = StoreQuery.EMPTY_STRINGS;
    public LinkedMap parameterTypes = StoreQuery.EMPTY_PARAMS;
    public int operation = 1;
    public ClassMetaData[] accessPath = StoreQuery.EMPTY_METAS;
    public String[] fetchPaths = StoreQuery.EMPTY_STRINGS;
    public String[] fetchInnerPaths = StoreQuery.EMPTY_STRINGS;
    public Value[] range = EMPTY_VALUES;
    private Boolean _aggregate = null;

    public boolean isAggregate() {
        if (this.projections.length == 0) {
            return false;
        }
        if (this._aggregate == null) {
            this._aggregate = AggregateExpressionVisitor.isAggregate(this.projections) ? Boolean.TRUE : Boolean.FALSE;
        }
        return this._aggregate;
    }

    public void putUpdate(Path path, Value val) {
        if (this.updates == Collections.EMPTY_MAP) {
            this.updates = new HashMap();
        }
        this.updates.put(path, val);
    }

    private static class AggregateExpressionVisitor
    extends AbstractExpressionVisitor {
        private Value _sub = null;
        private boolean _agg = false;

        private AggregateExpressionVisitor() {
        }

        public static boolean isAggregate(Value[] vals) {
            if (vals.length == 0) {
                return false;
            }
            AggregateExpressionVisitor v = new AggregateExpressionVisitor();
            for (int i = 0; i < vals.length && !v._agg; ++i) {
                vals[i].acceptVisit(v);
            }
            return v._agg;
        }

        public void enter(Value val) {
            if (this._agg) {
                return;
            }
            if (this._sub == null) {
                if (val.isAggregate()) {
                    this._agg = true;
                }
            } else if (val instanceof Subquery) {
                this._sub = val;
            }
        }

        public void exit(Value val) {
            if (val == this._sub) {
                this._sub = null;
            }
        }
    }
}

