/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.sql.SQLException;
import java.sql.Statement;

public class ReportingSQLException
extends SQLException {
    private final transient Statement _stmnt;
    private final SQLException _sqle;

    public ReportingSQLException(SQLException sqle, Statement stmnt, String sql2) {
        super(ReportingSQLException.getExceptionMessage(sqle, stmnt, sql2));
        this._sqle = sqle;
        this._stmnt = stmnt;
        this.setNextException(sqle);
    }

    public ReportingSQLException(SQLException sqle, String sql2) {
        this(sqle, null, sql2);
    }

    public ReportingSQLException(SQLException sqle, Statement stmnt) {
        this(sqle, stmnt, null);
    }

    public String getSQLState() {
        return this._sqle.getSQLState();
    }

    public int getErrorCode() {
        return this._sqle.getErrorCode();
    }

    public Statement getStatement() {
        return this._stmnt;
    }

    private static String getExceptionMessage(SQLException sqle, Statement stmnt, String sql2) {
        try {
            if (stmnt != null) {
                return sqle.getMessage() + " {" + stmnt + "} " + "[code=" + sqle.getErrorCode() + ", state=" + sqle.getSQLState() + "]";
            }
            if (sql2 != null) {
                return sqle.getMessage() + " {" + sql2 + "} " + "[code=" + sqle.getErrorCode() + ", state=" + sqle.getSQLState() + "]";
            }
            return sqle.getMessage() + " " + "[code=" + sqle.getErrorCode() + ", state=" + sqle.getSQLState() + "]";
        }
        catch (Throwable t) {
            return sqle.getMessage();
        }
    }
}

