/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepHandler;
import com.tonicsystems.jarjar.PathClass;
import com.tonicsystems.jarjar.asm.commons.EmptyVisitor;
import com.tonicsystems.jarjar.asm.commons.Remapper;
import com.tonicsystems.jarjar.asm.commons.RemappingClassAdapter;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;

class DepFindVisitor
extends RemappingClassAdapter {
    public DepFindVisitor(Map classes, Object source, DepHandler handler) throws IOException {
        super(new EmptyVisitor(), new DepFindRemapper(classes, source, handler));
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ((DepFindRemapper)this.remapper).setClassName(name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    private static String getSourceName(Object source) throws IOException {
        if (source instanceof ZipFile) {
            return ((ZipFile)source).getName();
        }
        return ((File)source).getCanonicalPath();
    }

    private static class DepFindRemapper
    extends Remapper {
        private final Map classes;
        private final String source;
        private final DepHandler handler;
        private PathClass curPathClass;

        public DepFindRemapper(Map classes, Object source, DepHandler handler) throws IOException {
            this.classes = classes;
            this.source = DepFindVisitor.getSourceName(source);
            this.handler = handler;
        }

        public void setClassName(String name) {
            this.curPathClass = new PathClass(this.source, name);
        }

        public String map(String key) {
            try {
                String otherSource;
                if (this.classes.containsKey(key) && !this.source.equals(otherSource = DepFindVisitor.getSourceName(this.classes.get(key)))) {
                    this.handler.handle(this.curPathClass, new PathClass(otherSource, key));
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            return null;
        }
    }
}

