/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.security;

import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.remote.MBeanServerForwarder;

public abstract class MBeanServerAccessController
implements MBeanServerForwarder {
    private MBeanServer mbs;

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        if (mBeanServer == null) {
            throw new IllegalArgumentException("Null MBeanServer");
        }
        if (this.mbs != null) {
            throw new IllegalArgumentException("MBeanServer object already initialized");
        }
        this.mbs = mBeanServer;
    }

    protected abstract void checkRead();

    protected abstract void checkWrite();

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.checkRead();
        this.getMBeanServer().addNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        this.checkRead();
        this.getMBeanServer().addNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.checkWrite();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            Object object = this.getMBeanServer().instantiate(string);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, objectName);
        }
        return this.getMBeanServer().createMBean(string, objectName);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        this.checkWrite();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            Object object = this.getMBeanServer().instantiate(string, objectArray, stringArray);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, objectName);
        }
        return this.getMBeanServer().createMBean(string, objectName, objectArray, stringArray);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkWrite();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            Object object = this.getMBeanServer().instantiate(string, objectName2);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, objectName);
        }
        return this.getMBeanServer().createMBean(string, objectName, objectName2);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        this.checkWrite();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            Object object = this.getMBeanServer().instantiate(string, objectName2, objectArray, stringArray);
            this.checkClassLoader(object);
            return this.getMBeanServer().registerMBean(object, objectName);
        }
        return this.getMBeanServer().createMBean(string, objectName, objectName2, objectArray, stringArray);
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        this.checkRead();
        return this.getMBeanServer().deserialize(objectName, byArray);
    }

    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().deserialize(string, byArray);
    }

    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().deserialize(string, objectName, byArray);
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().getAttribute(objectName, string);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().getAttributes(objectName, stringArray);
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().getClassLoader(objectName);
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().getClassLoaderFor(objectName);
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        this.checkRead();
        return this.getMBeanServer().getClassLoaderRepository();
    }

    public String getDefaultDomain() {
        this.checkRead();
        return this.getMBeanServer().getDefaultDomain();
    }

    public String[] getDomains() {
        this.checkRead();
        return this.getMBeanServer().getDomains();
    }

    public Integer getMBeanCount() {
        this.checkRead();
        return this.getMBeanServer().getMBeanCount();
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        this.checkRead();
        return this.getMBeanServer().getMBeanInfo(objectName);
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().getObjectInstance(objectName);
    }

    public Object instantiate(String string) throws ReflectionException, MBeanException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(string);
    }

    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(string, objectArray, stringArray);
    }

    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(string, objectName);
    }

    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        this.checkWrite();
        return this.getMBeanServer().instantiate(string, objectName, objectArray, stringArray);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        this.checkWrite();
        this.checkMLetAddURL(objectName, string);
        return this.getMBeanServer().invoke(objectName, string, objectArray, stringArray);
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        this.checkRead();
        return this.getMBeanServer().isInstanceOf(objectName, string);
    }

    public boolean isRegistered(ObjectName objectName) {
        this.checkRead();
        return this.getMBeanServer().isRegistered(objectName);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        this.checkRead();
        return this.getMBeanServer().queryMBeans(objectName, queryExp);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        this.checkRead();
        return this.getMBeanServer().queryNames(objectName, queryExp);
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.checkWrite();
        return this.getMBeanServer().registerMBean(object, objectName);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(objectName, notificationListener);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(objectName, objectName2);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.checkRead();
        this.getMBeanServer().removeNotificationListener(objectName, objectName2, notificationFilter, object);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.checkWrite();
        this.getMBeanServer().setAttribute(objectName, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        this.checkWrite();
        return this.getMBeanServer().setAttributes(objectName, attributeList);
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        this.checkWrite();
        this.getMBeanServer().unregisterMBean(objectName);
    }

    private void checkClassLoader(Object object) {
        if (object instanceof ClassLoader) {
            throw new SecurityException("Access denied! Creating an MBean that is a ClassLoader is forbidden unless a security manager is installed.");
        }
    }

    private void checkMLetAddURL(ObjectName objectName, String string) throws InstanceNotFoundException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null && string.equals("addURL") && this.getMBeanServer().isInstanceOf(objectName, "javax.management.loading.MLet")) {
            throw new SecurityException("Access denied! MLet method addURL cannot be invoked unless a security manager is installed.");
        }
    }
}

