/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.lang.util.Initializable;
import org.apache.shiro.realm.CachingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticatingRealm
extends CachingRealm
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatingRealm.class);
    private static final AtomicInteger INSTANCE_COUNT = new AtomicInteger();
    private static final String DEFAULT_AUTHENTICATION_CACHE_SUFFIX = ".authenticationCache";
    private CredentialsMatcher credentialsMatcher;
    private Cache<Object, AuthenticationInfo> authenticationCache;
    private boolean authenticationCachingEnabled = false;
    private String authenticationCacheName;
    private Class<? extends AuthenticationToken> authenticationTokenClass = UsernamePasswordToken.class;

    public AuthenticatingRealm() {
        this(null, new SimpleCredentialsMatcher());
    }

    public AuthenticatingRealm(CacheManager cacheManager) {
        this(cacheManager, new SimpleCredentialsMatcher());
    }

    public AuthenticatingRealm(CredentialsMatcher matcher) {
        this(null, matcher);
    }

    public AuthenticatingRealm(CacheManager cacheManager, CredentialsMatcher matcher) {
        int instanceNumber = INSTANCE_COUNT.getAndIncrement();
        this.authenticationCacheName = this.getClass().getName() + DEFAULT_AUTHENTICATION_CACHE_SUFFIX;
        if (instanceNumber > 0) {
            this.authenticationCacheName = this.authenticationCacheName + "." + instanceNumber;
        }
        if (cacheManager != null) {
            this.setCacheManager(cacheManager);
        }
        if (matcher != null) {
            this.setCredentialsMatcher(matcher);
        }
    }

    public CredentialsMatcher getCredentialsMatcher() {
        return this.credentialsMatcher;
    }

    public void setCredentialsMatcher(CredentialsMatcher credentialsMatcher) {
        this.credentialsMatcher = credentialsMatcher;
    }

    public Class<? extends AuthenticationToken> getAuthenticationTokenClass() {
        return this.authenticationTokenClass;
    }

    public void setAuthenticationTokenClass(Class<? extends AuthenticationToken> authenticationTokenClass) {
        this.authenticationTokenClass = authenticationTokenClass;
    }

    public void setAuthenticationCache(Cache<Object, AuthenticationInfo> authenticationCache) {
        this.authenticationCache = authenticationCache;
    }

    public Cache<Object, AuthenticationInfo> getAuthenticationCache() {
        return this.authenticationCache;
    }

    public String getAuthenticationCacheName() {
        return this.authenticationCacheName;
    }

    public void setAuthenticationCacheName(String authenticationCacheName) {
        this.authenticationCacheName = authenticationCacheName;
    }

    public boolean isAuthenticationCachingEnabled() {
        return this.authenticationCachingEnabled && this.isCachingEnabled();
    }

    public void setAuthenticationCachingEnabled(boolean authenticationCachingEnabled) {
        this.authenticationCachingEnabled = authenticationCachingEnabled;
        if (authenticationCachingEnabled) {
            this.setCachingEnabled(true);
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        String authcCacheName = this.authenticationCacheName;
        if (authcCacheName != null && authcCacheName.startsWith(this.getClass().getName())) {
            this.authenticationCacheName = name + DEFAULT_AUTHENTICATION_CACHE_SUFFIX;
        }
    }

    @Override
    public boolean supports(AuthenticationToken token) {
        return token != null && this.getAuthenticationTokenClass().isAssignableFrom(token.getClass());
    }

    public final void init() {
        this.getAvailableAuthenticationCache();
        this.onInit();
    }

    protected void onInit() {
    }

    @Override
    protected void afterCacheManagerSet() {
        this.getAvailableAuthenticationCache();
    }

    private Cache<Object, AuthenticationInfo> getAvailableAuthenticationCache() {
        Cache<Object, AuthenticationInfo> cache = this.getAuthenticationCache();
        boolean authcCachingEnabled = this.isAuthenticationCachingEnabled();
        if (cache == null && authcCachingEnabled) {
            cache = this.getAuthenticationCacheLazy();
        }
        return cache;
    }

    private Cache<Object, AuthenticationInfo> getAuthenticationCacheLazy() {
        if (this.authenticationCache == null) {
            LOGGER.trace("No authenticationCache instance set.  Checking for a cacheManager...");
            CacheManager cacheManager = this.getCacheManager();
            if (cacheManager != null) {
                String cacheName = this.getAuthenticationCacheName();
                LOGGER.debug("CacheManager [{}] configured.  Building authentication cache '{}'", (Object)cacheManager, (Object)cacheName);
                this.authenticationCache = cacheManager.getCache(cacheName);
            }
        }
        return this.authenticationCache;
    }

    private AuthenticationInfo getCachedAuthenticationInfo(AuthenticationToken token) {
        AuthenticationInfo info = null;
        Cache<Object, AuthenticationInfo> cache = this.getAvailableAuthenticationCache();
        if (cache != null && token != null) {
            LOGGER.trace("Attempting to retrieve the AuthenticationInfo from cache.");
            Object key = this.getAuthenticationCacheKey(token);
            info = (AuthenticationInfo)cache.get(key);
            if (info == null) {
                LOGGER.trace("No AuthenticationInfo found in cache for key [{}]", key);
            } else {
                LOGGER.trace("Found cached AuthenticationInfo for key [{}]", key);
            }
        }
        return info;
    }

    private void cacheAuthenticationInfoIfPossible(AuthenticationToken token, AuthenticationInfo info) {
        if (!this.isAuthenticationCachingEnabled(token, info)) {
            LOGGER.debug("AuthenticationInfo caching is disabled for info [{}].  Submitted token: [{}].", (Object)info, (Object)token);
            return;
        }
        Cache<Object, AuthenticationInfo> cache = this.getAvailableAuthenticationCache();
        if (cache != null) {
            Object key = this.getAuthenticationCacheKey(token);
            cache.put(key, (Object)info);
            LOGGER.trace("Cached AuthenticationInfo for continued authentication.  key=[{}], value=[{}].", key, (Object)info);
        }
    }

    protected boolean isAuthenticationCachingEnabled(AuthenticationToken token, AuthenticationInfo info) {
        return this.isAuthenticationCachingEnabled();
    }

    @Override
    public final AuthenticationInfo getAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        AuthenticationInfo info = this.getCachedAuthenticationInfo(token);
        if (info == null) {
            info = this.doGetAuthenticationInfo(token);
            LOGGER.debug("Looked up AuthenticationInfo [{}] from doGetAuthenticationInfo", (Object)info);
            if (token != null && info != null) {
                this.cacheAuthenticationInfoIfPossible(token, info);
            }
        } else {
            LOGGER.debug("Using cached authentication info [{}] to perform credentials matching.", (Object)info);
        }
        if (info != null) {
            this.assertCredentialsMatch(token, info);
        } else {
            LOGGER.debug("No AuthenticationInfo found for submitted AuthenticationToken [{}].  Returning null.", (Object)token);
        }
        return info;
    }

    protected void assertCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) throws AuthenticationException {
        CredentialsMatcher cm = this.getCredentialsMatcher();
        if (cm != null) {
            if (!cm.doCredentialsMatch(token, info)) {
                String msg = "Submitted credentials for token [" + String.valueOf(token) + "] did not match the expected credentials.";
                throw new IncorrectCredentialsException(msg);
            }
        } else {
            throw new AuthenticationException("A CredentialsMatcher must be configured in order to verify credentials during authentication.  If you do not wish for credentials to be examined, you can configure an " + AllowAllCredentialsMatcher.class.getName() + " instance.");
        }
    }

    protected Object getAuthenticationCacheKey(AuthenticationToken token) {
        return token != null ? token.getPrincipal() : null;
    }

    protected Object getAuthenticationCacheKey(PrincipalCollection principals) {
        return this.getAvailablePrincipal(principals);
    }

    @Override
    protected void doClearCache(PrincipalCollection principals) {
        super.doClearCache(principals);
        this.clearCachedAuthenticationInfo(principals);
    }

    private static boolean isEmpty(PrincipalCollection pc) {
        return pc == null || pc.isEmpty();
    }

    protected void clearCachedAuthenticationInfo(PrincipalCollection principals) {
        Cache<Object, AuthenticationInfo> cache;
        if (!AuthenticatingRealm.isEmpty(principals) && (cache = this.getAvailableAuthenticationCache()) != null) {
            Object key = this.getAuthenticationCacheKey(principals);
            cache.remove(key);
        }
    }

    protected abstract AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken var1) throws AuthenticationException;
}

