/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.CapabilityHeader;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.DirectiveFactory;
import org.apache.aries.subsystem.core.archive.EffectiveDirective;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.ProvideCapabilityCapability;
import org.apache.aries.subsystem.core.archive.TypedAttribute;
import org.osgi.resource.Resource;

public class ProvideCapabilityHeader
implements CapabilityHeader<Clause> {
    public static final String NAME = "Provide-Capability";
    private static final Pattern PATTERN = Pattern.compile("((?:[0-9]|[A-Za-z]|_|-)+(?:\\.(?:[0-9]|[A-Za-z]|_|-)+)*(?:;\\s*(?:(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+:=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+(?:\\:(?:String|Version|Long|Double)|List<(?:String|Version|Long|Double)>)?=(?:(?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))))*)(?=,|\\z)");
    private final Set<Clause> clauses = new HashSet<Clause>();

    public ProvideCapabilityHeader(String value) {
        Matcher matcher = PATTERN.matcher(value);
        while (matcher.find()) {
            this.clauses.add(new Clause(matcher.group()));
        }
        if (this.clauses.isEmpty()) {
            throw new IllegalArgumentException("A Provide-Capability header must have at least one clause");
        }
    }

    @Override
    public Collection<Clause> getClauses() {
        return Collections.unmodifiableSet(this.clauses);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<ProvideCapabilityCapability> toCapabilities(Resource resource) {
        ArrayList<ProvideCapabilityCapability> result = new ArrayList<ProvideCapabilityCapability>();
        for (Clause clause : this.clauses) {
            result.add(clause.toCapability(resource));
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Clause clause : this.getClauses()) {
            builder.append(clause).append(',');
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public static class Clause
    implements org.apache.aries.subsystem.core.archive.Clause {
        public static final String DIRECTIVE_EFFECTIVE = "effective";
        public static final String DIRECTIVE_USES = "uses";
        private static final String DIRECTIVE = "((?:[0-9]|[A-Za-z]|_|-|\\.)+)(:=)((?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")";
        private static final String TYPED_ATTR = "((?:[0-9]|[A-Za-z]|_|-|\\.)+)(?:(\\:)((?:String|Version|Long|Double)|List<(?:String|Version|Long|Double)>))?=((?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")";
        private static final Pattern PATTERN_NAMESPACE = Pattern.compile("((?:[0-9]|[A-Za-z]|_|-)+(?:\\.(?:[0-9]|[A-Za-z]|_|-)+)*)(?=;|\\z)");
        private static final Pattern PATTERN_PARAMETER = Pattern.compile("(?:(?:((?:[0-9]|[A-Za-z]|_|-|\\.)+)(:=)((?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\"))|(?:((?:[0-9]|[A-Za-z]|_|-|\\.)+)(?:(\\:)((?:String|Version|Long|Double)|List<(?:String|Version|Long|Double)>))?=((?:[0-9]|[A-Za-z]|_|-|\\.)+|\"(?:[^\\\\\"\r\n\u0000]|\\\\\"|\\\\\\\\)*\")))(?=;|\\z)");
        private final String path;
        private final Map<String, Parameter> parameters = new HashMap<String, Parameter>();

        private static void fillInDefaults(Map<String, Parameter> parameters) {
            Parameter parameter = parameters.get(DIRECTIVE_EFFECTIVE);
            if (parameter == null) {
                parameters.put(DIRECTIVE_EFFECTIVE, EffectiveDirective.DEFAULT);
            }
        }

        private static String removeQuotes(String value) {
            if (value == null) {
                return null;
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                return value.substring(1, value.length() - 1);
            }
            return value;
        }

        public Clause(String clause) {
            Matcher matcher = PATTERN_NAMESPACE.matcher(clause);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Missing namespace path: " + clause);
            }
            this.path = matcher.group();
            matcher.usePattern(PATTERN_PARAMETER);
            while (matcher.find()) {
                if (":=".equals(matcher.group(2))) {
                    this.parameters.put(matcher.group(1), DirectiveFactory.createDirective(matcher.group(1), Clause.removeQuotes(matcher.group(3))));
                    continue;
                }
                if (":".equals(matcher.group(5))) {
                    this.parameters.put(matcher.group(4), new TypedAttribute(matcher.group(4), Clause.removeQuotes(matcher.group(7)), matcher.group(6)));
                    continue;
                }
                this.parameters.put(matcher.group(4), new TypedAttribute(matcher.group(4), Clause.removeQuotes(matcher.group(7)), TypedAttribute.Type.String));
            }
            Clause.fillInDefaults(this.parameters);
        }

        @Override
        public Attribute getAttribute(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Attribute) {
                return (Attribute)result;
            }
            return null;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Attribute)) continue;
                attributes.add((TypedAttribute)parameter);
            }
            attributes.trimToSize();
            return attributes;
        }

        @Override
        public Directive getDirective(String name) {
            Parameter result = this.parameters.get(name);
            if (result instanceof Directive) {
                return (Directive)result;
            }
            return null;
        }

        @Override
        public Collection<Directive> getDirectives() {
            ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
            for (Parameter parameter : this.parameters.values()) {
                if (!(parameter instanceof Directive)) continue;
                directives.add((Directive)parameter);
            }
            directives.trimToSize();
            return directives;
        }

        public String getNamespace() {
            return this.path;
        }

        @Override
        public Parameter getParameter(String name) {
            return this.parameters.get(name);
        }

        @Override
        public Collection<Parameter> getParameters() {
            return Collections.unmodifiableCollection(this.parameters.values());
        }

        @Override
        public String getPath() {
            return this.path;
        }

        public ProvideCapabilityCapability toCapability(Resource resource) {
            return new ProvideCapabilityCapability(this, resource);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

