/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import org.apache.aries.subsystem.core.archive.DeploymentManifest;
import org.apache.aries.subsystem.core.archive.ProvisionResourceHeader;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemManifest;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.ResourceInstaller;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;
import org.osgi.service.coordinator.Coordination;
import org.osgi.service.coordinator.CoordinationException;
import org.osgi.service.subsystem.Subsystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static Coordination createCoordination() {
        return Activator.getInstance().getCoordinator().begin("org.osgi.service.subsystem.root-0", 0L);
    }

    public static Coordination createCoordination(BasicSubsystem subsystem) {
        return Activator.getInstance().getCoordinator().begin(subsystem.getSymbolicName() + '-' + subsystem.getSubsystemId(), 0L);
    }

    public static BasicSubsystem findFirstSubsystemAcceptingDependenciesStartingFrom(BasicSubsystem subsystem) {
        while (!Utils.isAcceptDependencies(subsystem)) {
            subsystem = (BasicSubsystem)subsystem.getParents().iterator().next();
        }
        return subsystem;
    }

    public static BasicSubsystem findScopedSubsystemInRegion(BasicSubsystem subsystem) {
        while (!subsystem.isScoped()) {
            subsystem = (BasicSubsystem)subsystem.getParents().iterator().next();
        }
        return subsystem;
    }

    public static int getActiveUseCount(Resource resource) {
        int result = 0;
        for (BasicSubsystem subsystem : Activator.getInstance().getSubsystems().getSubsystemsReferencing(resource)) {
            if (!Subsystem.State.ACTIVE.equals((Object)subsystem.getState())) continue;
            ++result;
        }
        return result;
    }

    public static long getId(Resource resource) {
        if (resource instanceof BasicSubsystem) {
            return ((BasicSubsystem)resource).getSubsystemId();
        }
        if (resource instanceof BundleRevision) {
            return ((BundleRevision)resource).getBundle().getBundleId();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installResource(Resource resource, BasicSubsystem subsystem) {
        Coordination coordination = Utils.createCoordination(subsystem);
        try {
            ResourceInstaller.newInstance(coordination, resource, subsystem).install();
        }
        catch (Throwable t) {
            coordination.fail(t);
        }
        finally {
            try {
                coordination.end();
            }
            catch (CoordinationException e) {
                logger.error("Resource could not be installed", (Throwable)e);
            }
        }
    }

    public static boolean isAcceptDependencies(BasicSubsystem subsystem) {
        return subsystem.getSubsystemManifest().getSubsystemTypeHeader().getProvisionPolicyDirective().isAcceptDependencies();
    }

    public static boolean isBundle(Resource resource) {
        String type = ResourceHelper.getTypeAttribute(resource);
        return "osgi.bundle".equals(type) || "osgi.fragment".equals(type);
    }

    public static boolean isContent(BasicSubsystem subsystem, Resource resource) {
        SubsystemManifest subsystemManifest = subsystem.getSubsystemManifest();
        if (subsystemManifest == null) {
            return false;
        }
        SubsystemContentHeader subsystemContentHeader = subsystemManifest.getSubsystemContentHeader();
        if (subsystemContentHeader == null) {
            return false;
        }
        return subsystemContentHeader.contains(resource);
    }

    public static boolean isDependency(BasicSubsystem subsystem, Resource resource) {
        DeploymentManifest manifest = subsystem.getDeploymentManifest();
        if (manifest == null) {
            return false;
        }
        ProvisionResourceHeader header = manifest.getProvisionResourceHeader();
        if (header == null) {
            return false;
        }
        return header.contains(resource);
    }

    public static boolean isInstallableResource(Resource resource) {
        return !Utils.isSharedResource(resource);
    }

    public static boolean isRegionContextBundle(Resource resource) {
        return ResourceHelper.getSymbolicNameAttribute(resource).startsWith("org.osgi.service.subsystem.region.context.");
    }

    public static boolean isSharedResource(Resource resource) {
        return resource instanceof BasicSubsystem || resource instanceof BundleRevision;
    }

    public static boolean isSubsystem(Resource resource) {
        String type = ResourceHelper.getTypeAttribute(resource);
        return "osgi.subsystem.application".equals(type) || "osgi.subsystem.composite".equals(type) || "osgi.subsystem.feature".equals(type);
    }
}

