/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.grpc;

import io.grpc.KnownLength;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Protocol;

public final class AvroGrpcUtils {
    private static final Logger LOG = Logger.getLogger(AvroGrpcUtils.class.getName());

    private AvroGrpcUtils() {
    }

    public static String getServiceName(Class iface) {
        Protocol protocol = AvroGrpcUtils.getProtocol(iface);
        return protocol.getNamespace() + "." + protocol.getName();
    }

    public static Protocol getProtocol(Class iface) {
        try {
            Protocol p = (Protocol)iface.getDeclaredField("PROTOCOL").get(null);
            return p;
        }
        catch (NoSuchFieldException e) {
            throw new AvroRuntimeException("Not a Specific protocol: " + String.valueOf(iface));
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    static void skipAndCloseQuietly(InputStream stream) {
        try {
            if (stream instanceof KnownLength && stream.available() > 0) {
                stream.skip(stream.available());
            } else {
                int read;
                byte[] skipBuffer = new byte[4096];
                while ((read = stream.read(skipBuffer)) >= skipBuffer.length) {
                }
            }
            stream.close();
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "failed to skip/close the input stream, may cause memory leak", e);
        }
    }
}

