/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.tool;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.idl.IdlFile;
import org.apache.avro.idl.IdlReader;
import org.apache.avro.tool.Tool;

public class IdlToSchemataTool
implements Tool {
    @Override
    public int run(InputStream in, PrintStream out, PrintStream err, List<String> args) throws Exception {
        boolean useJavaCC = "--useJavaCC".equals(this.getArg(args, 0, null));
        if (args.isEmpty() || args.size() > (useJavaCC ? 3 : 2) || this.isRequestingHelp(args)) {
            err.println("Usage: idl2schemata [--useJavaCC] [idl [outdir]]");
            err.println();
            err.println("If an output directory is not specified, outputs to current directory.");
            return -1;
        }
        String inputName = this.getArg(args, useJavaCC ? 1 : 0, "-");
        File inputFile = "-".equals(inputName) ? null : new File(inputName);
        File outputDirectory = this.getOutputDirectory(this.getArg(args, useJavaCC ? 2 : 1, ""));
        if (useJavaCC) {
            try (Idl parser = new Idl(inputFile);){
                Protocol protocol = parser.CompilationUnit();
                List warnings = parser.getWarningsAfterParsing();
                for (String warning : warnings) {
                    err.println("Warning: " + warning);
                }
                for (Schema schema : protocol.getTypes()) {
                    this.print(schema, outputDirectory);
                }
            }
        } else {
            IdlReader parser = new IdlReader();
            IdlFile idlFile = inputFile == null ? parser.parse(in) : parser.parse(inputFile.toPath());
            for (String warning : idlFile.getWarnings()) {
                err.println("Warning: " + warning);
            }
            for (Schema schema : idlFile.getNamedSchemas().values()) {
                this.print(schema, outputDirectory);
            }
        }
        return 0;
    }

    private boolean isRequestingHelp(List<String> args) {
        return args.size() == 1 && (args.get(0).equals("--help") || args.get(0).equals("-help"));
    }

    private String getArg(List<String> args, int index, String defaultValue) {
        if (index < args.size()) {
            return args.get(index);
        }
        return defaultValue;
    }

    private File getOutputDirectory(String dirname) {
        File outputDirectory = new File(dirname);
        outputDirectory.mkdirs();
        return outputDirectory;
    }

    private void print(Schema schema, File outputDirectory) throws FileNotFoundException {
        String dirpath = outputDirectory.getAbsolutePath();
        String filename = dirpath + "/" + schema.getName() + ".avsc";
        FileOutputStream fileOutputStream = new FileOutputStream(filename);
        PrintStream printStream = new PrintStream(fileOutputStream);
        printStream.println(schema.toString(true));
        printStream.close();
    }

    @Override
    public String getName() {
        return "idl2schemata";
    }

    @Override
    public String getShortDescription() {
        return "Extract JSON schemata of the types from an Avro IDL file";
    }
}

