/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

@InterfaceAudience.Private
public class ECPolicyLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ECPolicyLoader.class);
    private static final int LAYOUT_VERSION = 1;

    public List<ErasureCodingPolicy> loadPolicy(String policyFilePath) {
        try {
            File policyFile = this.getPolicyFile(policyFilePath);
            if (!policyFile.exists()) {
                LOG.warn("Not found any EC policy file");
                return Collections.emptyList();
            }
            return this.loadECPolicies(policyFile);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Failed to load EC policy file: " + policyFilePath);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ErasureCodingPolicy> loadECPolicies(File policyFile) throws ParserConfigurationException, IOException, SAXException {
        LOG.info("Loading EC policy file " + policyFile);
        DocumentBuilderFactory dbf = XMLUtils.newSecureDocumentBuilderFactory();
        dbf.setIgnoringComments(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document doc = builder.parse(policyFile);
        Element root = doc.getDocumentElement();
        if (!"configuration".equals(root.getTagName())) {
            throw new RuntimeException("Bad EC policy configuration file: top-level element not <configuration>");
        }
        if (root.getElementsByTagName("layoutversion").getLength() <= 0) throw new RuntimeException("Bad EC policy configuration file: no <layoutVersion> element");
        if (this.loadLayoutVersion(root) != 1) throw new RuntimeException("The parse failed because of bad layoutversion value");
        if (root.getElementsByTagName("schemas").getLength() <= 0) throw new RuntimeException("Bad EC policy configuration file: no <schemas> element");
        Map<String, ECSchema> schemas = this.loadSchemas(root);
        if (root.getElementsByTagName("policies").getLength() <= 0) throw new RuntimeException("Bad EC policy configuration file: no <policies> element");
        return this.loadPolicies(root, schemas);
    }

    private int loadLayoutVersion(Element root) {
        int layoutVersion;
        Text text = (Text)root.getElementsByTagName("layoutversion").item(0).getFirstChild();
        if (text != null) {
            String value = text.getData().trim();
            try {
                layoutVersion = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad layoutVersion value " + value + " is found. It should be an integer");
            }
        } else {
            throw new IllegalArgumentException("Value of <layoutVersion> is null");
        }
        return layoutVersion;
    }

    private Map<String, ECSchema> loadSchemas(Element root) {
        NodeList elements = root.getElementsByTagName("schemas").item(0).getChildNodes();
        HashMap<String, ECSchema> schemas = new HashMap<String, ECSchema>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if ("schema".equals(element.getTagName())) {
                String schemaId = element.getAttribute("id");
                ECSchema schema = this.loadSchema(element);
                if (!schemas.containsValue(schema)) {
                    schemas.put(schemaId, schema);
                    continue;
                }
                throw new RuntimeException("Repetitive schemas in EC policy configuration file: " + schemaId);
            }
            throw new RuntimeException("Bad element in EC policy configuration file: " + element.getTagName());
        }
        return schemas;
    }

    private List<ErasureCodingPolicy> loadPolicies(Element root, Map<String, ECSchema> schemas) {
        NodeList elements = root.getElementsByTagName("policies").item(0).getChildNodes();
        ArrayList<ErasureCodingPolicy> policies = new ArrayList<ErasureCodingPolicy>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node node = elements.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if ("policy".equals(element.getTagName())) {
                ErasureCodingPolicy policy = this.loadPolicy(element, schemas);
                if (!policies.contains(policy)) {
                    policies.add(policy);
                    continue;
                }
                LOG.warn("Repetitive policies in EC policy configuration file: " + policy.toString());
                continue;
            }
            throw new RuntimeException("Bad element in EC policy configuration file: " + element.getTagName());
        }
        return policies;
    }

    private File getPolicyFile(String policyFilePath) throws MalformedURLException {
        File policyFile = new File(policyFilePath);
        if (!policyFile.isAbsolute()) {
            URL url = new URL(policyFilePath);
            if (!url.getProtocol().equalsIgnoreCase("file")) {
                throw new RuntimeException("EC policy file " + url + " found on the classpath is not on the local filesystem.");
            }
            policyFile = new File(url.getPath());
        }
        return policyFile;
    }

    private ECSchema loadSchema(Element element) {
        HashMap<String, String> schemaOptions = new HashMap<String, String>();
        NodeList fields = element.getChildNodes();
        for (int i = 0; i < fields.getLength(); ++i) {
            Node fieldNode = fields.item(i);
            if (!(fieldNode instanceof Element)) continue;
            Element field = (Element)fieldNode;
            String tagName = field.getTagName();
            if ("k".equals(tagName)) {
                tagName = "numDataUnits";
            } else if ("m".equals(tagName)) {
                tagName = "numParityUnits";
            }
            Text text = (Text)field.getFirstChild();
            if (text != null) {
                String value = text.getData().trim();
                schemaOptions.put(tagName, value);
                continue;
            }
            throw new IllegalArgumentException("Value of <" + tagName + "> is null");
        }
        return new ECSchema(schemaOptions);
    }

    private ErasureCodingPolicy loadPolicy(Element element, Map<String, ECSchema> schemas) {
        NodeList fields = element.getChildNodes();
        ECSchema schema = null;
        int cellSize = 0;
        for (int i = 0; i < fields.getLength(); ++i) {
            Node fieldNode = fields.item(i);
            if (!(fieldNode instanceof Element)) continue;
            Element field = (Element)fieldNode;
            String tagName = field.getTagName();
            Text text = (Text)field.getFirstChild();
            if (text != null) {
                if (text.isElementContentWhitespace()) continue;
                String value = text.getData().trim();
                if ("schema".equals(tagName)) {
                    schema = schemas.get(value);
                    continue;
                }
                if ("cellsize".equals(tagName)) {
                    try {
                        cellSize = Integer.parseInt(value);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Bad EC policy cellsize value " + value + " is found. It should be an integer");
                    }
                }
                LOG.warn("Invalid tagName: " + tagName);
                continue;
            }
            throw new IllegalArgumentException("Value of <" + tagName + "> is null");
        }
        if (schema != null && cellSize > 0) {
            return new ErasureCodingPolicy(schema, cellSize);
        }
        throw new RuntimeException("Bad policy is found in EC policy configuration file");
    }
}

