/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public enum TimelineEntityType {
    YARN_CLUSTER,
    YARN_FLOW_RUN,
    YARN_APPLICATION,
    YARN_APPLICATION_ATTEMPT,
    YARN_CONTAINER,
    YARN_USER,
    YARN_QUEUE,
    YARN_FLOW_ACTIVITY;


    public boolean isParent(TimelineEntityType type) {
        switch (this) {
            case YARN_CLUSTER: {
                return false;
            }
            case YARN_FLOW_RUN: {
                return YARN_FLOW_RUN == type || YARN_CLUSTER == type;
            }
            case YARN_APPLICATION: {
                return YARN_FLOW_RUN == type || YARN_CLUSTER == type;
            }
            case YARN_APPLICATION_ATTEMPT: {
                return YARN_APPLICATION == type;
            }
            case YARN_CONTAINER: {
                return YARN_APPLICATION_ATTEMPT == type;
            }
            case YARN_QUEUE: {
                return YARN_QUEUE == type;
            }
        }
        return false;
    }

    public boolean isChild(TimelineEntityType type) {
        switch (this) {
            case YARN_CLUSTER: {
                return YARN_FLOW_RUN == type || YARN_APPLICATION == type;
            }
            case YARN_FLOW_RUN: {
                return YARN_FLOW_RUN == type || YARN_APPLICATION == type;
            }
            case YARN_APPLICATION: {
                return YARN_APPLICATION_ATTEMPT == type;
            }
            case YARN_APPLICATION_ATTEMPT: {
                return YARN_CONTAINER == type;
            }
            case YARN_CONTAINER: {
                return false;
            }
            case YARN_QUEUE: {
                return YARN_QUEUE == type;
            }
        }
        return false;
    }

    public boolean matches(String typeString) {
        return this.toString().equals(typeString);
    }
}

