/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.trevni.BZip2Codec;
import org.apache.trevni.DeflateCodec;
import org.apache.trevni.MetaData;
import org.apache.trevni.NullCodec;
import org.apache.trevni.SnappyCodec;
import org.apache.trevni.TrevniRuntimeException;

abstract class Codec {
    Codec() {
    }

    public static Codec get(MetaData meta) {
        String name = meta.getCodec();
        if (name == null || "null".equals(name)) {
            return new NullCodec();
        }
        if ("deflate".equals(name)) {
            return new DeflateCodec();
        }
        if ("snappy".equals(name)) {
            return new SnappyCodec();
        }
        if ("bzip2".equals(name)) {
            return new BZip2Codec();
        }
        throw new TrevniRuntimeException("Unknown codec: " + name);
    }

    abstract ByteBuffer compress(ByteBuffer var1) throws IOException;

    abstract ByteBuffer decompress(ByteBuffer var1) throws IOException;

    protected static int computeOffset(ByteBuffer data) {
        return data.arrayOffset() + data.position();
    }
}

