/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.cipher;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import org.apache.commons.crypto.cipher.AbstractOpenSslFeedbackCipher;
import org.apache.commons.crypto.cipher.OpenSslEvpCtrlValues;
import org.apache.commons.crypto.cipher.OpenSslNative;

final class OpenSslGaloisCounterMode
extends AbstractOpenSslFeedbackCipher {
    static final int DEFAULT_TAG_LEN = 16;
    private ByteArrayOutputStream aadBuffer = new ByteArrayOutputStream();
    private int tagBitLen = -1;
    private ByteArrayOutputStream inBuffer;

    public OpenSslGaloisCounterMode(long context, int algorithmMode, int padding) {
        super(context, algorithmMode, padding);
    }

    @Override
    public void clean() {
        super.clean();
        this.aadBuffer = null;
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int len;
        this.checkState();
        this.processAAD();
        int outputLength = output.length;
        if (this.cipherMode == 0) {
            byte[] inputFinal;
            int inputOffsetFinal = inputOffset;
            int inputLenFinal = inputLen;
            if (this.inBuffer != null && this.inBuffer.size() > 0) {
                this.inBuffer.write(input, inputOffset, inputLen);
                inputFinal = this.inBuffer.toByteArray();
                inputOffsetFinal = 0;
                inputLenFinal = inputFinal.length;
                this.inBuffer.reset();
            } else {
                inputFinal = input;
            }
            if (inputFinal.length < this.getTagLen()) {
                throw new AEADBadTagException("Input too short - need tag");
            }
            int inputDataLen = inputLenFinal - this.getTagLen();
            len = OpenSslNative.updateByteArray(this.context, inputFinal, inputOffsetFinal, inputDataLen, output, outputOffset, outputLength - outputOffset);
            ByteBuffer tag = ByteBuffer.allocate(this.getTagLen());
            tag.put(input, input.length - this.getTagLen(), this.getTagLen());
            tag.flip();
            this.evpCipherCtxCtrl(this.context, OpenSslEvpCtrlValues.AEAD_SET_TAG.getValue(), this.getTagLen(), tag);
        } else {
            len = OpenSslNative.updateByteArray(this.context, input, inputOffset, inputLen, output, outputOffset, outputLength - outputOffset);
        }
        len += OpenSslNative.doFinalByteArray(this.context, output, outputOffset + len, outputLength - outputOffset - len);
        if (this.cipherMode == 1) {
            ByteBuffer tag = ByteBuffer.allocate(this.getTagLen());
            this.evpCipherCtxCtrl(this.context, OpenSslEvpCtrlValues.AEAD_GET_TAG.getValue(), this.getTagLen(), tag);
            tag.get(output, outputLength - this.getTagLen(), this.getTagLen());
            len += this.getTagLen();
        }
        return len;
    }

    @Override
    public int doFinal(ByteBuffer input, ByteBuffer output) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int len;
        ByteBuffer tag;
        this.checkState();
        this.processAAD();
        int totalLen = 0;
        if (this.cipherMode == 0) {
            tag = ByteBuffer.allocate(this.getTagLen());
            if (this.inBuffer != null && this.inBuffer.size() > 0) {
                byte[] inputBytes = new byte[input.remaining()];
                input.get(inputBytes, 0, inputBytes.length);
                this.inBuffer.write(inputBytes, 0, inputBytes.length);
                byte[] inputFinal = this.inBuffer.toByteArray();
                this.inBuffer.reset();
                if (inputFinal.length < this.getTagLen()) {
                    throw new AEADBadTagException("Input too short - need tag");
                }
                len = OpenSslNative.updateByteArrayByteBuffer(this.context, inputFinal, 0, inputFinal.length - this.getTagLen(), output, output.position(), output.remaining());
                tag.put(inputFinal, inputFinal.length - this.getTagLen(), this.getTagLen());
            } else {
                if (input.remaining() < this.getTagLen()) {
                    throw new AEADBadTagException("Input too short - need tag");
                }
                len = OpenSslNative.update(this.context, input, input.position(), input.remaining() - this.getTagLen(), output, output.position(), output.remaining());
                input.position(input.position() + len);
                tag.put(input);
            }
            tag.flip();
            this.evpCipherCtxCtrl(this.context, OpenSslEvpCtrlValues.AEAD_SET_TAG.getValue(), this.getTagLen(), tag);
        } else {
            len = OpenSslNative.update(this.context, input, input.position(), input.remaining(), output, output.position(), output.remaining());
            input.position(input.limit());
        }
        totalLen += len;
        output.position(output.position() + len);
        len = OpenSslNative.doFinal(this.context, output, output.position(), output.remaining());
        output.position(output.position() + len);
        totalLen += len;
        if (this.cipherMode == 1) {
            tag = ByteBuffer.allocate(this.getTagLen());
            this.evpCipherCtxCtrl(this.context, OpenSslEvpCtrlValues.AEAD_GET_TAG.getValue(), this.getTagLen(), tag);
            output.put(tag);
            totalLen += this.getTagLen();
        }
        return totalLen;
    }

    private int evpCipherCtxCtrl(long context, int type, int arg, ByteBuffer data) {
        this.checkState();
        try {
            if (data != null) {
                data.order(ByteOrder.nativeOrder());
                return OpenSslNative.ctrl(context, type, arg, data.array());
            }
            return OpenSslNative.ctrl(context, type, arg, null);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return 0;
        }
    }

    private int getTagLen() {
        return this.tagBitLen < 0 ? 16 : this.tagBitLen >> 3;
    }

    @Override
    public void init(int mode, byte[] key, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (this.aadBuffer == null) {
            this.aadBuffer = new ByteArrayOutputStream();
        } else {
            this.aadBuffer.reset();
        }
        this.cipherMode = mode;
        if (!(params instanceof GCMParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Illegal parameters");
        }
        GCMParameterSpec gcmParam = (GCMParameterSpec)params;
        byte[] iv = gcmParam.getIV();
        this.tagBitLen = gcmParam.getTLen();
        if (this.cipherMode == 0) {
            this.inBuffer = new ByteArrayOutputStream();
        }
        this.context = OpenSslNative.init(this.context, mode, this.algorithmMode, this.padding, key, iv);
    }

    private void processAAD() {
        if (this.aadBuffer != null && this.aadBuffer.size() > 0) {
            OpenSslNative.updateByteArray(this.context, this.aadBuffer.toByteArray(), 0, this.aadBuffer.size(), null, 0, 0);
            this.aadBuffer = null;
        }
    }

    @Override
    public int update(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.checkState();
        this.processAAD();
        if (this.cipherMode == 0) {
            this.inBuffer.write(input, inputOffset, inputLen);
            return 0;
        }
        return OpenSslNative.updateByteArray(this.context, input, inputOffset, inputLen, output, outputOffset, output.length - outputOffset);
    }

    @Override
    public int update(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        this.checkState();
        this.processAAD();
        if (this.cipherMode == 0) {
            int inputLen = input.remaining();
            byte[] inputBuf = new byte[inputLen];
            input.get(inputBuf, 0, inputLen);
            this.inBuffer.write(inputBuf, 0, inputLen);
            return 0;
        }
        int len = OpenSslNative.update(this.context, input, input.position(), input.remaining(), output, output.position(), output.remaining());
        input.position(input.limit());
        output.position(output.position() + len);
        return len;
    }

    @Override
    public void updateAAD(byte[] aad) {
        if (this.aadBuffer == null) {
            throw new IllegalStateException("Update has been called; no more AAD data");
        }
        this.aadBuffer.write(aad, 0, aad.length);
    }
}

