/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class PragmaTest
extends JexlTestCase {
    public PragmaTest() {
        super("PragmaTest");
    }

    @Test
    public void testPragmas() throws Exception {
        MapContext jc = new MapContext();
        JexlScript script = this.JEXL.createScript("#pragma one 1\n#pragma the.very.hard 'truth'\n2;");
        Assert.assertNotNull((Object)script);
        Map pragmas = script.getPragmas();
        Assert.assertEquals((long)2L, (long)pragmas.size());
        Assert.assertEquals((Object)1, pragmas.get("one"));
        Assert.assertEquals((Object)"truth", pragmas.get("the.very.hard"));
    }

    @Test
    public void testJxltPragmas() throws Exception {
        MapContext jc = new MapContext();
        JxltEngine engine = new JexlBuilder().create().createJxltEngine();
        JxltEngine.Template tscript = engine.createTemplate("$$ #pragma one 1\n$$ #pragma the.very.hard 'truth'\n2;");
        Assert.assertNotNull((Object)tscript);
        Map pragmas = tscript.getPragmas();
        Assert.assertEquals((long)2L, (long)pragmas.size());
        Assert.assertEquals((Object)1, pragmas.get("one"));
        Assert.assertEquals((Object)"truth", pragmas.get("the.very.hard"));
    }

    @Test
    public void testSafePragma() throws Exception {
        SafeContext jc = new SafeContext();
        jc.set("foo", null);
        JexlScript script = this.JEXL.createScript("#pragma jexl.safe true\nfoo.bar;");
        Assert.assertNotNull((Object)script);
        jc.processPragmas(script.getPragmas());
        Object result = script.execute((JexlContext)jc);
        Assert.assertNull((Object)result);
        jc = new SafeContext();
        jc.set("foo", null);
        try {
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"should have thrown");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    @Test
    public void testStaticNamespacePragma() throws Exception {
        SafeContext jc = new SafeContext();
        JexlScript script = this.JEXL.createScript("#pragma jexl.namespace.sleeper " + StaticSleeper.class.getName() + "\nsleeper:sleep(100);42");
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testStatictNamespacePragmaCtl() throws Exception {
        Map<String, String> ns = Collections.singletonMap("sleeper", StaticSleeper.class.getName());
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        SafeContext jc = new SafeContext();
        JexlScript script = jexl.createScript("sleeper:sleep(100);42");
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNamespacePragma() throws Exception {
        SafeContext jc = new SafeContext();
        JexlScript script = this.JEXL.createScript("#pragma jexl.namespace.sleeper " + Sleeper.class.getName() + "\nsleeper:sleep(100);42");
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNamespacePragmaCtl() throws Exception {
        Map<String, String> ns = Collections.singletonMap("sleeper", Sleeper.class.getName());
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        SafeContext jc = new SafeContext();
        JexlScript script = jexl.createScript("sleeper:sleep(100);42");
        Object result = script.execute((JexlContext)jc);
        Assert.assertEquals((Object)42, (Object)result);
    }

    public static class Sleeper {
        public void sleep(long ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class StaticSleeper {
        private StaticSleeper() {
        }

        public static void sleep(long ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class SafeContext
    extends JexlEvalContext {
        public void processPragmas(Map<String, Object> pragmas) {
            if (pragmas != null && !pragmas.isEmpty()) {
                JexlOptions options = this.getEngineOptions();
                for (Map.Entry<String, Object> pragma : pragmas.entrySet()) {
                    String key = pragma.getKey();
                    Object value = pragma.getValue();
                    if ("jexl.safe".equals(key) && value instanceof Boolean) {
                        options.setSafe(((Boolean)value).booleanValue());
                        continue;
                    }
                    if ("jexl.strict".equals(key) && value instanceof Boolean) {
                        options.setStrict(((Boolean)value).booleanValue());
                        continue;
                    }
                    if (!"jexl.silent".equals(key) || !(value instanceof Boolean)) continue;
                    options.setSilent(((Boolean)value).booleanValue());
                }
            }
        }

        public void sleep(long ms) {
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

