/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class WhileTest
extends JexlTestCase {
    public WhileTest() {
        super("WhileTest");
    }

    @Test
    public void testSimpleWhileFalse() throws Exception {
        JexlScript e = this.JEXL.createScript("while (false) ;");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertNull((String)"Result is not null", (Object)o);
    }

    @Test
    public void testWhileExecutesExpressionWhenLooping() throws Exception {
        JexlScript e = this.JEXL.createScript("while (x < 10) x = x + 1;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(1));
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is wrong", (Object)new Integer(10), (Object)o);
    }

    @Test
    public void testWhileWithBlock() throws Exception {
        JexlScript e = this.JEXL.createScript("while (x < 10) { x = x + 1; y = y * 2; }");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(1));
        jc.set("y", (Object)new Integer(1));
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is wrong", (Object)new Integer(512), (Object)o);
        Assert.assertEquals((String)"x is wrong", (Object)new Integer(10), (Object)jc.get("x"));
        Assert.assertEquals((String)"y is wrong", (Object)new Integer(512), (Object)jc.get("y"));
    }
}

