/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.core;

import org.apache.commons.numbers.core.DD;

final class ExtendedPrecision {
    private static final double SAFE_UPPER = 6.696928794914171E299;
    private static final double SAFE_LOWER = 4.008336720017946E-292;
    private static final double DOWN_SCALE = 9.313225746154785E-10;
    private static final double UP_SCALE = 1.073741824E9;
    private static final double UP_SCALE2 = 1.152921504606847E18;
    private static final double DOWN_SCALE2 = 8.673617379884035E-19;

    private ExtendedPrecision() {
    }

    static double productLow(double x, double y, double xy) {
        double ab;
        double b;
        if (DD.isNotNormal(xy)) {
            return xy - xy;
        }
        double a = Math.abs(x);
        if (a + (b = Math.abs(y)) + (ab = Math.abs(xy)) >= 6.696928794914171E299) {
            if (a > b) {
                return DD.twoProductLow(x * 9.313225746154785E-10, y, xy * 9.313225746154785E-10) * 1.073741824E9;
            }
            return DD.twoProductLow(x, y * 9.313225746154785E-10, xy * 9.313225746154785E-10) * 1.073741824E9;
        }
        if (ab <= 4.008336720017946E-292) {
            return DD.twoProductLow(x * 1.073741824E9, y * 1.073741824E9, xy * 1.152921504606847E18) * 8.673617379884035E-19;
        }
        return DD.twoProductLow(x, y, xy);
    }
}

