/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.numbers.gamma;

import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import org.apache.commons.numbers.core.Sum;
import org.apache.commons.numbers.fraction.GeneralizedContinuedFraction;
import org.apache.commons.numbers.gamma.BoostErf;
import org.apache.commons.numbers.gamma.BoostMath;
import org.apache.commons.numbers.gamma.BoostTools;
import org.apache.commons.numbers.gamma.InvGamma1pm1;
import org.apache.commons.numbers.gamma.Policy;
import org.apache.commons.numbers.gamma.SpecialMath;

final class BoostGamma {
    private static final double EPSILON = 2.220446049250313E-16;
    private static final double ROOT_EPSILON = 1.4901161193847656E-8;
    private static final int LOG_MAX_VALUE = 709;
    private static final int LOG_MIN_VALUE = -708;
    private static final int MAX_FACTORIAL = 170;
    private static final int MAX_GAMMA_Z = 171;
    private static final double LOG_ROOT_TWO_PI = 0.9189385332046728;
    private static final double LOG_PI = 1.1447298858494002;
    private static final double EULER = 0.5772156649015329;
    private static final int LANCZOS_THRESHOLD = 20;
    private static final double TWO_POW_53 = 9.007199254740992E15;
    private static final double[] FACTORIAL = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21, 2.585201673888498E22, 6.204484017332394E23, 1.5511210043330986E25, 4.0329146112660565E26, 1.0888869450418352E28, 3.0488834461171387E29, 8.841761993739702E30, 2.6525285981219107E32, 8.222838654177922E33, 2.631308369336935E35, 8.683317618811886E36, 2.9523279903960416E38, 1.0333147966386145E40, 3.7199332678990125E41, 1.3763753091226346E43, 5.230226174666011E44, 2.0397882081197444E46, 8.159152832478977E47, 3.345252661316381E49, 1.40500611775288E51, 6.041526306337383E52, 2.658271574788449E54, 1.1962222086548019E56, 5.502622159812089E57, 2.5862324151116818E59, 1.2413915592536073E61, 6.082818640342675E62, 3.0414093201713376E64, 1.5511187532873822E66, 8.065817517094388E67, 4.2748832840600255E69, 2.308436973392414E71, 1.2696403353658276E73, 7.109985878048635E74, 4.0526919504877214E76, 2.3505613312828785E78, 1.3868311854568984E80, 8.32098711274139E81, 5.075802138772248E83, 3.146997326038794E85, 1.98260831540444E87, 1.2688693218588417E89, 8.247650592082472E90, 5.443449390774431E92, 3.647111091818868E94, 2.4800355424368305E96, 1.711224524281413E98, 1.1978571669969892E100, 8.504785885678623E101, 6.1234458376886085E103, 4.4701154615126844E105, 3.307885441519386E107, 2.48091408113954E109, 1.8854947016660504E111, 1.4518309202828587E113, 1.1324281178206297E115, 8.946182130782976E116, 7.156945704626381E118, 5.797126020747368E120, 4.753643337012842E122, 3.945523969720659E124, 3.314240134565353E126, 2.81710411438055E128, 2.4227095383672734E130, 2.107757298379528E132, 1.8548264225739844E134, 1.650795516090846E136, 1.4857159644817615E138, 1.352001527678403E140, 1.2438414054641308E142, 1.1567725070816416E144, 1.087366156656743E146, 1.032997848823906E148, 9.916779348709496E149, 9.619275968248212E151, 9.426890448883248E153, 9.332621544394415E155, 9.332621544394415E157, 9.42594775983836E159, 9.614466715035127E161, 9.90290071648618E163, 1.0299016745145628E166, 1.081396758240291E168, 1.1462805637347084E170, 1.226520203196138E172, 1.324641819451829E174, 1.4438595832024937E176, 1.588245541522743E178, 1.7629525510902446E180, 1.974506857221074E182, 2.2311927486598138E184, 2.5435597334721877E186, 2.925093693493016E188, 3.393108684451898E190, 3.969937160808721E192, 4.684525849754291E194, 5.574585761207606E196, 6.689502913449127E198, 8.094298525273444E200, 9.875044200833601E202, 1.214630436702533E205, 1.506141741511141E207, 1.882677176888926E209, 2.372173242880047E211, 3.0126600184576594E213, 3.856204823625804E215, 4.974504222477287E217, 6.466855489220474E219, 8.47158069087882E221, 1.1182486511960043E224, 1.4872707060906857E226, 1.9929427461615188E228, 2.6904727073180504E230, 3.659042881952549E232, 5.012888748274992E234, 6.917786472619489E236, 9.615723196941089E238, 1.3462012475717526E241, 1.898143759076171E243, 2.695364137888163E245, 3.854370717180073E247, 5.5502938327393044E249, 8.047926057471992E251, 1.1749972043909107E254, 1.727245890454639E256, 2.5563239178728654E258, 3.80892263763057E260, 5.713383956445855E262, 8.62720977423324E264, 1.3113358856834524E267, 2.0063439050956823E269, 3.0897696138473508E271, 4.789142901463394E273, 7.471062926282894E275, 1.1729568794264145E278, 1.853271869493735E280, 2.9467022724950384E282, 4.7147236359920616E284, 7.590705053947219E286, 1.2296942187394494E289, 2.0044015765453026E291, 3.287218585534296E293, 5.423910666131589E295, 9.003691705778438E297, 1.503616514864999E300, 2.5260757449731984E302, 4.269068009004705E304, 7.257415615307999E306};

    private BoostGamma() {
    }

    static double[] getFactorials() {
        return (double[])FACTORIAL.clone();
    }

    static double uncheckedFactorial(int n) {
        return FACTORIAL[n];
    }

    static double tgamma(double z) {
        if (Math.rint(z) == z) {
            if (z <= 0.0) {
                return Double.NaN;
            }
            if (z <= 171.0) {
                return FACTORIAL[(int)z - 1];
            }
            return Double.POSITIVE_INFINITY;
        }
        if (Math.abs(z) <= 20.0) {
            if (z >= 1.0) {
                double prod = 1.0;
                double t = z;
                while (t > 2.5) {
                    prod *= (t -= 1.0);
                }
                return prod / (1.0 + InvGamma1pm1.value(t - 1.0));
            }
            double prod = z;
            double t = z;
            while (t < -0.5) {
                prod *= (t += 1.0);
            }
            return 1.0 / (prod * (1.0 + InvGamma1pm1.value(t)));
        }
        if (z < 0.0) {
            return -Math.PI / (BoostGamma.sinpx(z) * BoostGamma.tgamma(-z));
        }
        if (z > 172.0) {
            return Double.POSITIVE_INFINITY;
        }
        double result = Lanczos.lanczosSum(z);
        double zgh = z + 5.52468004077673;
        double lzgh = Math.log(zgh);
        if (z * lzgh > 709.0) {
            double hp = Math.pow(zgh, z / 2.0 - 0.25);
            result *= hp / Math.exp(zgh);
            result *= hp;
        } else {
            result *= Math.pow(zgh, z - 0.5) / Math.exp(zgh);
        }
        return result;
    }

    static double sinpx(double x) {
        double dist;
        int sign = 1;
        double fl = Math.floor(x = -x);
        if (BoostGamma.isOdd(fl)) {
            dist = (fl += 1.0) - x;
            sign = -sign;
        } else {
            dist = x - fl;
        }
        if (dist > 0.5) {
            dist = 1.0 - dist;
        }
        double result = Math.sin(dist * Math.PI);
        return (double)sign * x * result;
    }

    private static boolean isOdd(double v) {
        return ((long)(-v) & 1L) == 1L;
    }

    static double lgamma(double z) {
        return BoostGamma.lgamma(z, null);
    }

    static double lgamma(double z, int[] sign) {
        double result;
        int sresult = 1;
        if (z <= -1.4901161193847656E-8) {
            if (Math.rint(z) == z) {
                return Double.NaN;
            }
            double t = BoostGamma.sinpx(z);
            z = -z;
            if (t < 0.0) {
                t = -t;
            } else {
                sresult = -sresult;
            }
            result = Sum.of((double)(-BoostGamma.lgamma(z))).add(-Math.log(t)).add(1.1447298858494002).getAsDouble();
        } else if (z < 1.4901161193847656E-8) {
            if (z == 0.0) {
                return Double.NaN;
            }
            result = 4.0 * Math.abs(z) < 2.220446049250313E-16 ? -Math.log(Math.abs(z)) : Math.log(Math.abs(1.0 / z - 0.5772156649015329));
            if (z < 0.0) {
                sresult = -1;
            }
        } else if (z < 15.0) {
            result = BoostGamma.lgammaSmall(z, z - 1.0, z - 2.0);
        } else if (z < 100.0) {
            result = Math.log(BoostGamma.tgamma(z));
        } else {
            double zgh = z + 5.52468004077673;
            result = Math.log(zgh) - 1.0;
            if ((result *= z - 0.5) * 2.220446049250313E-16 < 20.0) {
                result += Math.log(Lanczos.lanczosSumExpGScaled(z));
            }
        }
        if (BoostGamma.nonZeroLength(sign)) {
            sign[0] = sresult;
        }
        return result;
    }

    private static double lgammaSmall(double z, double zm1, double zm2) {
        Sum result = Sum.create();
        if (zm1 == 0.0 || zm2 == 0.0) {
            return 0.0;
        }
        if (z > 2.0) {
            if (z >= 3.0) {
                do {
                    result.add(Math.log(z -= 1.0));
                } while (z >= 3.0);
                zm2 = z - 2.0;
            }
            double P2 = -3.245886498259485E-5;
            P2 = -5.410098692152044E-4 + P2 * zm2;
            P2 = -2.594535632054381E-4 + P2 * zm2;
            P2 = 0.0172491608709614 + P2 * zm2;
            P2 = 0.049410315156753225 + P2 * zm2;
            P2 = 0.02512664961998968 + P2 * zm2;
            P2 = -0.01803556856784494 + P2 * zm2;
            double Q2 = -2.2335276320861708E-7;
            Q2 = 2.2493629192211576E-4 + Q2 * zm2;
            Q2 = 0.008213096746488934 + Q2 * zm2;
            Q2 = 0.09885042511280101 + Q2 * zm2;
            Q2 = 0.5413914320717209 + Q2 * zm2;
            Q2 = 1.4801966942423133 + Q2 * zm2;
            Q2 = 1.962029871977952 + Q2 * zm2;
            Q2 = 1.0 + Q2 * zm2;
            float Y = 0.15896368f;
            double r = zm2 * (z + 1.0);
            double R = P2 / Q2;
            result.addProduct(r, 0.15896368026733398).addProduct(r, R);
        } else {
            if (z < 1.0) {
                result.add(-Math.log(z));
                zm2 = zm1;
                zm1 = z;
                z += 1.0;
            }
            if (z <= 1.5) {
                float Y = 0.5281534f;
                double P3 = -0.0010034668769627955;
                P3 = -0.024014982064857155 + P3 * zm1;
                P3 = -0.1584135863906922 + P3 * zm1;
                P3 = -0.4065671242119384 + P3 * zm1;
                P3 = -0.4149833583594954 + P3 * zm1;
                P3 = -0.09691175301595212 + P3 * zm1;
                P3 = 0.04906224540690395 + P3 * zm1;
                double Q3 = 0.001957681026011072;
                Q3 = 0.05770397226904519 + Q3 * zm1;
                Q3 = 0.5071377386143635 + Q3 * zm1;
                Q3 = 1.9141558827442668 + Q3 * zm1;
                Q3 = 3.4873958536072385 + Q3 * zm1;
                Q3 = 3.0234982984646304 + Q3 * zm1;
                Q3 = 1.0 + Q3 * zm1;
                double r = P3 / Q3;
                double prefix = zm1 * zm2;
                result.addProduct(prefix, 0.5281534194946289).addProduct(prefix, r);
            } else {
                float Y = 0.4520173f;
                double mzm2 = -zm2;
                double P4 = 4.311713426792973E-4;
                P4 = -0.008505359768683364 + P4 * mzm2;
                P4 = 0.05428096940550536 + P4 * mzm2;
                P4 = -0.14244039073863127 + P4 * mzm2;
                P4 = 0.14421626775719232 + P4 * mzm2;
                P4 = -0.029232972183027003 + P4 * mzm2;
                double Q4 = -8.271935218912905E-7;
                Q4 = -0.0010066679553914337 + Q4 * mzm2;
                Q4 = 0.02558279715597587 + Q4 * mzm2;
                Q4 = -0.22009515181499575 + Q4 * mzm2;
                Q4 = 0.846973248876495 + Q4 * mzm2;
                Q4 = -1.5016935605448505 + Q4 * mzm2;
                Q4 = 1.0 + Q4 * mzm2;
                double r = zm2 * zm1;
                double R = P4 / Q4;
                result.addProduct(r, (double)0.4520173f).addProduct(r, R);
            }
        }
        return result.getAsDouble();
    }

    static double tgamma1pm1(double dz) {
        double result = dz < 0.0 ? (dz < -0.5 ? BoostGamma.tgamma(1.0 + dz) - 1.0 : Math.expm1(-Math.log1p(dz) + BoostGamma.lgammaSmall(dz + 2.0, dz + 1.0, dz))) : (dz < 2.0 ? Math.expm1(BoostGamma.lgammaSmall(dz + 1.0, dz, dz - 1.0)) : BoostGamma.tgamma(1.0 + dz) - 1.0);
        return result;
    }

    static double tgamma(double a, double x) {
        return BoostGamma.gammaIncompleteImp(a, x, false, true, Policy.getDefault());
    }

    static double tgamma(double a, double x, Policy policy) {
        return BoostGamma.gammaIncompleteImp(a, x, false, true, policy);
    }

    static double tgammaLower(double a, double x) {
        return BoostGamma.gammaIncompleteImp(a, x, false, false, Policy.getDefault());
    }

    static double tgammaLower(double a, double x, Policy policy) {
        return BoostGamma.gammaIncompleteImp(a, x, false, false, policy);
    }

    static double gammaQ(double a, double x) {
        return BoostGamma.gammaIncompleteImp(a, x, true, true, Policy.getDefault());
    }

    static double gammaQ(double a, double x, Policy policy) {
        return BoostGamma.gammaIncompleteImp(a, x, true, true, policy);
    }

    static double gammaP(double a, double x) {
        return BoostGamma.gammaIncompleteImp(a, x, true, false, Policy.getDefault());
    }

    static double gammaP(double a, double x, Policy policy) {
        return BoostGamma.gammaIncompleteImp(a, x, true, false, policy);
    }

    static double gammaPDerivative(double a, double x) {
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            return Double.NaN;
        }
        if (x == 0.0) {
            if (a > 1.0) {
                return 0.0;
            }
            return a == 1.0 ? 1.0 : Double.POSITIVE_INFINITY;
        }
        double f1 = BoostGamma.regularisedGammaPrefix(a, x);
        if (f1 == 0.0) {
            f1 = a * Math.log(x) - x - BoostGamma.lgamma(a) - Math.log(x);
            f1 = Math.exp(f1);
        } else {
            f1 /= x;
        }
        return f1;
    }

    private static double gammaIncompleteImp(double a, double x, boolean normalised, boolean invert, Policy pol) {
        int evalMethod;
        boolean isHalfInt;
        boolean isInt;
        boolean isSmallA;
        if (Double.isNaN(a) || Double.isNaN(x) || a <= 0.0 || x < 0.0) {
            return Double.NaN;
        }
        double result = 0.0;
        if (a >= 170.0 && !normalised) {
            if (invert && a * 4.0 < x) {
                result = a * Math.log(x) - x;
                result += Math.log(BoostGamma.upperGammaFraction(a, x, pol));
            } else if (!invert && a > 4.0 * x) {
                result = a * Math.log(x) - x;
                result += Math.log(BoostGamma.lowerGammaSeries(a, x, 0.0, pol) / a);
            } else {
                result = BoostGamma.gammaIncompleteImp(a, x, true, invert, pol);
                if (result == 0.0) {
                    if (invert) {
                        result = 1.0 + 1.0 / (12.0 * a) + 1.0 / (288.0 * a * a);
                        result = Math.log(result) - a + (a - 0.5) * Math.log(a) + 0.9189385332046728;
                    } else {
                        result = a * Math.log(x) - x;
                        result += Math.log(BoostGamma.lowerGammaSeries(a, x, 0.0, pol) / a);
                    }
                } else {
                    result = Math.log(result) + BoostGamma.lgamma(a);
                }
            }
            return Math.exp(result);
        }
        boolean bl = isSmallA = a < 30.0 && a <= x + 1.0 && -x > -708.0;
        if (isSmallA) {
            double fa = Math.floor(a);
            isInt = fa == a;
            isHalfInt = !isInt && Math.abs(fa - a) == 0.5;
        } else {
            isHalfInt = false;
            isInt = false;
        }
        if (isInt && x > 0.6) {
            invert = !invert;
            evalMethod = 0;
        } else if (isHalfInt && x > 0.2) {
            invert = !invert;
            evalMethod = 1;
        } else if (x < 1.4901161193847656E-8 && a > 1.0) {
            evalMethod = 6;
        } else if (x > 1000.0 && a < x * 0.75) {
            invert = !invert;
            evalMethod = 7;
        } else if (x < 0.5) {
            evalMethod = -0.4 / Math.log(x) < a ? 2 : 3;
        } else if (x < 1.1) {
            evalMethod = x * 0.75 < a ? 2 : 3;
        } else {
            boolean useTemme = false;
            if (normalised && a > 20.0) {
                double sigma = Math.abs((x - a) / a);
                if (a > 200.0) {
                    if (20.0 / a > sigma * sigma) {
                        useTemme = true;
                    }
                } else if (sigma < 0.4) {
                    useTemme = true;
                }
            }
            if (useTemme) {
                evalMethod = 5;
            } else if (x - 1.0 / (3.0 * x) < a) {
                evalMethod = 2;
            } else {
                evalMethod = 4;
                invert = !invert;
            }
        }
        switch (evalMethod) {
            case 0: {
                result = BoostGamma.finiteGammaQ(a, x);
                if (normalised) break;
                result *= BoostGamma.tgamma(a);
                break;
            }
            case 1: {
                result = BoostGamma.finiteHalfGammaQ(a, x);
                if (normalised) break;
                result *= BoostGamma.tgamma(a);
                break;
            }
            case 2: {
                double d = result = normalised ? BoostGamma.regularisedGammaPrefix(a, x) : BoostGamma.fullIgammaPrefix(a, x);
                if (result == 0.0) break;
                double initValue = 0.0;
                boolean optimisedInvert = false;
                if (invert) {
                    double d2 = initValue = normalised ? 1.0 : BoostGamma.tgamma(a);
                    if (normalised || result >= 1.0 || Double.MAX_VALUE * result > initValue) {
                        initValue /= result;
                        if (normalised || a < 1.0 || Double.MAX_VALUE / a > initValue) {
                            initValue *= -a;
                            optimisedInvert = true;
                        } else {
                            initValue = 0.0;
                        }
                    } else {
                        initValue = 0.0;
                    }
                }
                result *= BoostGamma.lowerGammaSeries(a, x, initValue, pol) / a;
                if (!optimisedInvert) break;
                invert = false;
                result = -result;
                break;
            }
            case 3: {
                invert = !invert;
                double[] g = new double[]{0.0};
                result = BoostGamma.tgammaSmallUpperPart(a, x, pol, g, invert);
                invert = false;
                if (!normalised) break;
                if (g[0] == Double.POSITIVE_INFINITY) {
                    result = Math.exp(Math.log(result) - BoostGamma.lgamma(a));
                    break;
                }
                result /= g[0];
                break;
            }
            case 4: {
                double d = result = normalised ? BoostGamma.regularisedGammaPrefix(a, x) : BoostGamma.fullIgammaPrefix(a, x);
                if (result == 0.0) break;
                result *= BoostGamma.upperGammaFraction(a, x, pol);
                break;
            }
            case 5: {
                result = BoostGamma.igammaTemmeLarge(a, x);
                if (!(x >= a)) break;
                invert = !invert;
                break;
            }
            case 6: {
                result = normalised ? Math.pow(x, a) / BoostGamma.tgamma(a + 1.0) : Math.pow(x, a) / a;
                result *= 1.0 - a * x / (a + 1.0);
                break;
            }
            default: {
                double d = result = normalised ? BoostGamma.regularisedGammaPrefix(a, x) : BoostGamma.fullIgammaPrefix(a, x);
                if ((result /= x) == 0.0) break;
                result *= BoostGamma.incompleteTgammaLargeX(a, x, pol);
            }
        }
        if (normalised && result > 1.0) {
            result = 1.0;
        }
        if (invert) {
            double gam = normalised ? 1.0 : BoostGamma.tgamma(a);
            result = gam - result;
        }
        return result;
    }

    static double upperGammaFraction(final double a, double z, Policy pol) {
        double eps = pol.getEps();
        int maxIterations = pol.getMaxIterations();
        final double zma1 = z - a + 1.0;
        Supplier<GeneralizedContinuedFraction.Coefficient> gen = new Supplier<GeneralizedContinuedFraction.Coefficient>(){
            private int k;

            @Override
            public GeneralizedContinuedFraction.Coefficient get() {
                ++this.k;
                return GeneralizedContinuedFraction.Coefficient.of((double)((double)this.k * (a - (double)this.k)), (double)(zma1 + 2.0 * (double)this.k));
            }
        };
        return 1.0 / GeneralizedContinuedFraction.value((double)zma1, (Supplier)gen, (double)eps, (int)maxIterations);
    }

    private static double finiteGammaQ(double a, double x) {
        double sum;
        double term = sum = Math.exp(-x);
        int n = 1;
        while ((double)n < a) {
            term /= (double)n;
            sum += (term *= x);
            ++n;
        }
        return sum;
    }

    private static double finiteHalfGammaQ(double a, double x) {
        double e = BoostErf.erfc(Math.sqrt(x));
        if (a > 1.0) {
            double term = Math.exp(-x) / Math.sqrt(Math.PI * x);
            term *= x;
            double sum = term /= 0.5;
            int n = 2;
            while ((double)n < a) {
                term /= (double)n - 0.5;
                sum += (term *= x);
                ++n;
            }
            e += sum;
        }
        return e;
    }

    static double lowerGammaSeries(final double a, final double z, double initValue, Policy pol) {
        double eps = pol.getEps();
        int maxIterations = pol.getMaxIterations();
        DoubleSupplier gen = new DoubleSupplier(){
            private double result = 1.0;
            private int n;

            @Override
            public double getAsDouble() {
                double r = this.result;
                ++this.n;
                this.result *= z / (a + (double)this.n);
                return r;
            }
        };
        return BoostTools.kahanSumSeries(gen, eps, maxIterations, initValue);
    }

    private static double tgammaSmallUpperPart(final double a, final double x, Policy pol, double[] pgam, boolean invert) {
        double result = BoostGamma.tgamma1pm1(a);
        pgam[0] = (result + 1.0) / a;
        double p = BoostMath.powm1(x, a);
        result -= p;
        result /= a;
        int maxIter = pol.getMaxIterations();
        double initValue = invert ? pgam[0] : 0.0;
        DoubleSupplier gen = new DoubleSupplier(){
            private double result;
            private final double z;
            private int n;
            {
                this.result = -x;
                this.z = -x;
                this.n = 1;
            }

            @Override
            public double getAsDouble() {
                double r = this.result / (a + (double)this.n);
                ++this.n;
                this.result = this.result * this.z / (double)this.n;
                return r;
            }
        };
        result = -(p += 1.0) * BoostTools.kahanSumSeries(gen, pol.getEps(), maxIter, (initValue - result) / p);
        if (invert) {
            result = -result;
        }
        return result;
    }

    static double fullIgammaPrefix(double a, double z) {
        if (z > Double.MAX_VALUE) {
            return 0.0;
        }
        double alz = a * Math.log(z);
        double prefix = z >= 1.0 ? (alz < 709.0 && -z > -708.0 ? Math.pow(z, a) * Math.exp(-z) : (a >= 1.0 ? Math.pow(z / Math.exp(z / a), a) : Math.exp(alz - z))) : (alz > -708.0 ? Math.pow(z, a) * Math.exp(-z) : Math.pow(z / Math.exp(z / a), a));
        return prefix;
    }

    static double regularisedGammaPrefix(double a, double z) {
        double prefix;
        double amz;
        double d;
        if (z >= Double.MAX_VALUE) {
            return 0.0;
        }
        if (a <= 1.0) {
            if (-z <= -708.0) {
                return Math.exp(a * Math.log(z) - z - BoostGamma.lgamma(a));
            }
            return Math.pow(z, a) * Math.exp(-z) / BoostGamma.tgamma(a);
        }
        if (a <= 171.0) {
            double alz1 = a * Math.log(z);
            if (z >= 1.0 ? alz1 < 709.0 && -z > -708.0 : alz1 > -708.0) {
                return Math.pow(z, a) * Math.exp(-z) / BoostGamma.tgamma(a);
            }
        }
        double agh = a + 5.52468004077673;
        double factor = Math.sqrt(agh / Math.E) / Lanczos.lanczosSumExpGScaled(a);
        if (a > 128.0 && Math.abs((d = (z - a - 5.52468004077673) / agh) * d * a) <= 100.0) {
            double prefix2 = a * SpecialMath.log1pmx(d) + z * -5.52468004077673 / agh;
            prefix2 = Math.exp(prefix2);
            return prefix2 * factor;
        }
        double alz = a * Math.log(z / agh);
        if (Math.min(alz, amz = a - z) <= -708.0 || Math.max(alz, amz) >= 709.0) {
            double amza = amz / a;
            if (Math.min(alz, amz) / 2.0 > -708.0 && Math.max(alz, amz) / 2.0 < 709.0) {
                double sq = Math.pow(z / agh, a / 2.0) * Math.exp(amz / 2.0);
                prefix = sq * sq;
            } else if (Math.min(alz, amz) / 4.0 > -708.0 && Math.max(alz, amz) / 4.0 < 709.0 && z > a) {
                double sq = Math.pow(z / agh, a / 4.0) * Math.exp(amz / 4.0);
                prefix = sq * sq;
                prefix *= prefix;
            } else {
                prefix = amza > -708.0 && amza < 709.0 ? Math.pow(z * Math.exp(amza) / agh, a) : Math.exp(alz + amz);
            }
        } else {
            prefix = Math.pow(z / agh, a) * Math.exp(amz);
        }
        return prefix *= factor;
    }

    static double igammaTemmeLarge(double a, double x) {
        double sigma = (x - a) / a;
        double phi = -SpecialMath.log1pmx(sigma);
        double y = a * phi;
        double z = Math.sqrt(2.0 * phi);
        if (x < a) {
            z = -z;
        }
        double[] workspace = new double[10];
        double[] C0 = new double[]{-0.3333333333333333, 0.08333333333333333, -0.014814814814814815, 0.0011574074074074073, 3.527336860670194E-4, -1.787551440329218E-4, 3.919263178522438E-5, -2.1854485106799924E-6, -1.85406221071516E-6, 8.296711340953087E-7, -1.7665952736826078E-7, 6.707853543401498E-9, 1.0261809784240309E-8, -4.382036018453353E-9, 9.14769958223679E-10};
        workspace[0] = BoostTools.evaluatePolynomial(C0, z);
        double[] C1 = new double[]{-0.001851851851851852, -0.003472222222222222, 0.0026455026455026454, -9.902263374485596E-4, 2.0576131687242798E-4, -4.018775720164609E-7, -1.8098550334489977E-5, 7.64916091608111E-6, -1.6120900894563446E-6, 4.647127802807434E-9, 1.378633446915721E-7, -5.752545603517705E-8, 1.1951628599778148E-8};
        workspace[1] = BoostTools.evaluatePolynomial(C1, z);
        double[] C2 = new double[]{0.004133597883597883, -0.0026813271604938273, 7.716049382716049E-4, 2.0093878600823047E-6, -1.0736653226365161E-4, 5.2923448829120125E-5, -1.2760635188618728E-5, 3.423578734096138E-8, 1.3721957309062932E-6, -6.298992138380055E-7, 1.4280614206064242E-7};
        workspace[2] = BoostTools.evaluatePolynomial(C2, z);
        double[] C3 = new double[]{6.494341563786008E-4, 2.2947209362139917E-4, -4.691894943952557E-4, 2.6772063206283885E-4, -7.561801671883977E-5, -2.396505113867297E-7, 1.1082654115347302E-5, -5.6749528269915965E-6, 1.4230900732435883E-6};
        workspace[3] = BoostTools.evaluatePolynomial(C3, z);
        double[] C4 = new double[]{-8.618882909167117E-4, 7.840392217200666E-4, -2.990724803031902E-4, -1.4638452578843418E-6, 6.641498215465122E-5, -3.968365047179435E-5, 1.1375726970678419E-5};
        workspace[4] = BoostTools.evaluatePolynomial(C4, z);
        double[] C5 = new double[]{-3.3679855336635813E-4, -6.972813758365858E-5, 2.772753244959392E-4, -1.9932570516188847E-4, 6.797780477937208E-5, 1.419062920643967E-7, -1.3594048189768693E-5, 8.018470256334202E-6, -2.291481176508095E-6};
        workspace[5] = BoostTools.evaluatePolynomial(C5, z);
        double[] C6 = new double[]{5.313079364639922E-4, -5.921664373536939E-4, 2.708782096718045E-4, 7.902353232660328E-7, -8.153969367561969E-5, 5.61168275310625E-5, -1.8329116582843375E-5};
        workspace[6] = BoostTools.evaluatePolynomial(C6, z);
        double[] C7 = new double[]{3.4436760689237765E-4, 5.171790908260592E-5, -3.3493161081142234E-4, 2.812695154763237E-4, -1.0976582244684731E-4};
        workspace[7] = BoostTools.evaluatePolynomial(C7, z);
        double[] C8 = new double[]{-6.526239185953094E-4, 8.394987206720873E-4, -4.38297098541721E-4};
        workspace[8] = BoostTools.evaluatePolynomial(C8, z);
        workspace[9] = -5.967612901927463E-4;
        double result = BoostTools.evaluatePolynomial(workspace, 1.0 / a);
        result *= Math.exp(-y) / Math.sqrt(Math.PI * 2 * a);
        if (x < a) {
            result = -result;
        }
        return result += BoostErf.erfc(Math.sqrt(y)) / 2.0;
    }

    static double incompleteTgammaLargeX(final double a, final double x, Policy pol) {
        double eps = pol.getEps();
        int maxIterations = pol.getMaxIterations();
        DoubleSupplier gen = new DoubleSupplier(){
            private double term = 1.0;
            private int n;

            @Override
            public double getAsDouble() {
                double result = this.term;
                ++this.n;
                this.term *= (a - (double)this.n) / x;
                return result;
            }
        };
        return BoostTools.kahanSumSeries(gen, eps, maxIterations);
    }

    private static boolean nonZeroLength(int[] array) {
        return array != null && array.length != 0;
    }

    static double tgammaDeltaRatio(double z, double delta) {
        double zDelta = z + delta;
        if (Double.isNaN(zDelta)) {
            return Double.NaN;
        }
        if (z <= 0.0 || zDelta <= 0.0) {
            return BoostGamma.tgamma(z) / BoostGamma.tgamma(zDelta);
        }
        if (Math.rint(delta) == delta) {
            if (delta == 0.0) {
                return 1.0;
            }
            if (Math.rint(z) == z && z <= 171.0 && zDelta <= 171.0) {
                return FACTORIAL[(int)z - 1] / FACTORIAL[(int)zDelta - 1];
            }
            if (Math.abs(delta) < 20.0) {
                if (delta < 0.0) {
                    double result = z -= 1.0;
                    for (int d = (int)(delta + 1.0); d != 0; ++d) {
                        result *= (z -= 1.0);
                    }
                    return result;
                }
                double result = 1.0 / z;
                for (int d = (int)(delta - 1.0); d != 0; --d) {
                    result /= (z += 1.0);
                }
                return result;
            }
        }
        return BoostGamma.tgammaDeltaRatioImpLanczos(z, delta);
    }

    private static double tgammaDeltaRatioImpLanczos(double z, double delta) {
        double result;
        if (z < 2.220446049250313E-16) {
            if (171.0 < delta) {
                double ratio = BoostGamma.tgammaDeltaRatioImpLanczos(delta, 171.0 - delta);
                ratio *= z;
                return 1.0 / (ratio *= FACTORIAL[170]);
            }
            return 1.0 / (z * BoostGamma.tgamma(z + delta));
        }
        double zgh = z + 5.52468004077673;
        if (z + delta == z) {
            result = Math.exp(-delta);
        } else {
            result = Math.abs(delta) < 10.0 ? Math.exp((0.5 - z) * Math.log1p(delta / zgh)) : Math.pow(zgh / (zgh + delta), z - 0.5);
            result *= Lanczos.lanczosSum(z) / Lanczos.lanczosSum(z + delta);
        }
        return result *= Math.pow(Math.E / (zgh + delta), delta);
    }

    static double tgammaRatio(double x, double y) {
        if (x <= 0.0 || !Double.isFinite(x) || y <= 0.0 || !Double.isFinite(y)) {
            return Double.NaN;
        }
        if (x <= Double.MIN_NORMAL) {
            return 9.007199254740992E15 * BoostGamma.tgammaRatio(x * 9.007199254740992E15, y);
        }
        if (x <= 171.0 && y <= 171.0) {
            return BoostGamma.tgamma(x) / BoostGamma.tgamma(y);
        }
        double prefix = 1.0;
        if (x < 1.0) {
            if (y < 342.0) {
                prefix /= x;
                x += 1.0;
                while (y >= 171.0) {
                    prefix /= (y -= 1.0);
                }
                return prefix * BoostGamma.tgamma(x) / BoostGamma.tgamma(y);
            }
            return Math.exp(BoostGamma.lgamma(x) - BoostGamma.lgamma(y));
        }
        if (y < 1.0) {
            if (x < 342.0) {
                prefix *= y;
                y += 1.0;
                while (x >= 171.0) {
                    prefix *= (x -= 1.0);
                }
                return prefix * BoostGamma.tgamma(x) / BoostGamma.tgamma(y);
            }
            return Math.exp(BoostGamma.lgamma(x) - BoostGamma.lgamma(y));
        }
        return BoostGamma.tgammaDeltaRatio(x, y - x);
    }

    static final class Lanczos {
        static final double G = 6.02468004077673;
        static final double GMH = 5.52468004077673;
        private static final int[] DENOM = new int[]{0, 39916800, 120543840, 150917976, 105258076, 45995730, 13339535, 2637558, 357423, 32670, 1925, 66, 1};

        private Lanczos() {
        }

        static double lanczosSum(double z) {
            double[] num = new double[]{2.353137688041076E10, 4.29198036426491E10, 3.571195923735567E10, 1.792103442603721E10, 6.039542586352028E9, 1.4397204073117216E9, 2.4887455786205417E8, 3.1426415585400194E7, 2876370.6289353725, 186056.26539522348, 8071.672002365816, 210.82427775157936, 2.5066282746310002};
            return Lanczos.evaluateRational(num, DENOM, z);
        }

        static double lanczosSumExpGScaled(double z) {
            double[] num = new double[]{5.6906521913471565E7, 1.0379404311634454E8, 8.63631312881386E7, 4.333888932467614E7, 1.4605578087685067E7, 3481712.154980646, 601859.6171681099, 75999.29304014542, 6955.999602515376, 449.9445569063168, 19.519927882476175, 0.5098416655656676, 0.006061842346248907};
            return Lanczos.evaluateRational(num, DENOM, z);
        }

        private static double evaluateRational(double[] a, int[] b, double x) {
            if (x <= 1.0) {
                double x2 = x * x;
                double t0 = a[12] * x2 + a[10];
                double t1 = a[11] * x2 + a[9];
                double t2 = (double)b[12] * x2 + (double)b[10];
                double t3 = (double)b[11] * x2 + (double)b[9];
                t0 *= x2;
                t1 *= x2;
                t2 *= x2;
                t3 *= x2;
                t0 += a[8];
                t1 += a[7];
                t2 += (double)b[8];
                t3 += (double)b[7];
                t0 *= x2;
                t1 *= x2;
                t2 *= x2;
                t3 *= x2;
                t0 += a[6];
                t1 += a[5];
                t2 += (double)b[6];
                t3 += (double)b[5];
                t0 *= x2;
                t1 *= x2;
                t2 *= x2;
                t3 *= x2;
                t0 += a[4];
                t1 += a[3];
                t2 += (double)b[4];
                t3 += (double)b[3];
                t0 *= x2;
                t1 *= x2;
                t2 *= x2;
                t3 *= x2;
                t0 += a[2];
                t1 += a[1];
                t2 += (double)b[2];
                t3 += (double)b[1];
                t0 *= x2;
                t2 *= x2;
                return ((t0 += a[0]) + (t1 *= x)) / ((t2 += (double)b[0]) + (t3 *= x));
            }
            double z = 1.0 / x;
            double z2 = 1.0 / (x * x);
            double t0 = a[0] * z2 + a[2];
            double t1 = a[1] * z2 + a[3];
            double t2 = (double)b[0] * z2 + (double)b[2];
            double t3 = (double)b[1] * z2 + (double)b[3];
            t0 *= z2;
            t1 *= z2;
            t2 *= z2;
            t3 *= z2;
            t0 += a[4];
            t1 += a[5];
            t2 += (double)b[4];
            t3 += (double)b[5];
            t0 *= z2;
            t1 *= z2;
            t2 *= z2;
            t3 *= z2;
            t0 += a[6];
            t1 += a[7];
            t2 += (double)b[6];
            t3 += (double)b[7];
            t0 *= z2;
            t1 *= z2;
            t2 *= z2;
            t3 *= z2;
            t0 += a[8];
            t1 += a[9];
            t2 += (double)b[8];
            t3 += (double)b[9];
            t0 *= z2;
            t1 *= z2;
            t2 *= z2;
            t3 *= z2;
            t0 += a[10];
            t1 += a[11];
            t2 += (double)b[10];
            t3 += (double)b[11];
            t0 *= z2;
            t2 *= z2;
            return ((t0 += a[12]) + (t1 *= z)) / ((t2 += (double)b[12]) + (t3 *= z));
        }
    }
}

