/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.DiscreteUniformSampler;
import org.apache.commons.rng.sampling.distribution.InternalUtils;
import org.apache.commons.rng.sampling.distribution.SamplerBase;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;

public class RejectionInversionZipfSampler
extends SamplerBase
implements SharedStateDiscreteSampler {
    private final SharedStateDiscreteSampler delegate;

    public RejectionInversionZipfSampler(UniformRandomProvider rng, int numberOfElements, double exponent) {
        this(RejectionInversionZipfSampler.of(rng, numberOfElements, exponent));
    }

    private RejectionInversionZipfSampler(SharedStateDiscreteSampler delegate) {
        super(null);
        this.delegate = delegate;
    }

    @Override
    public int sample() {
        return this.delegate.sample();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
        return (SharedStateDiscreteSampler)this.delegate.withUniformRandomProvider(rng);
    }

    public static SharedStateDiscreteSampler of(UniformRandomProvider rng, int numberOfElements, double exponent) {
        if (numberOfElements <= 0) {
            throw new IllegalArgumentException("number of elements is not strictly positive: " + numberOfElements);
        }
        InternalUtils.requirePositive(exponent, "exponent");
        return exponent > 0.0 ? new RejectionInversionZipfSamplerImpl(rng, numberOfElements, exponent) : DiscreteUniformSampler.of(rng, 1, numberOfElements);
    }

    private static final class RejectionInversionZipfSamplerImpl
    implements SharedStateDiscreteSampler {
        private static final double TAYLOR_THRESHOLD = 1.0E-8;
        private static final double F_1_2 = 0.5;
        private static final double F_1_3 = 0.3333333333333333;
        private static final double F_1_4 = 0.25;
        private final int numberOfElements;
        private final double exponent;
        private final double hIntegralX1;
        private final double hIntegralNumberOfElements;
        private final double r;
        private final double s;
        private final UniformRandomProvider rng;

        RejectionInversionZipfSamplerImpl(UniformRandomProvider rng, int numberOfElements, double exponent) {
            this.rng = rng;
            this.numberOfElements = numberOfElements;
            this.exponent = exponent;
            this.hIntegralX1 = this.hIntegral(1.5) - 1.0;
            this.hIntegralNumberOfElements = this.hIntegral((double)numberOfElements + 0.5);
            this.r = this.hIntegralX1 - this.hIntegralNumberOfElements;
            this.s = 2.0 - this.hIntegralInverse(this.hIntegral(2.5) - this.h(2.0));
        }

        private RejectionInversionZipfSamplerImpl(UniformRandomProvider rng, RejectionInversionZipfSamplerImpl source) {
            this.rng = rng;
            this.numberOfElements = source.numberOfElements;
            this.exponent = source.exponent;
            this.hIntegralX1 = source.hIntegralX1;
            this.hIntegralNumberOfElements = source.hIntegralNumberOfElements;
            this.r = source.r;
            this.s = source.s;
        }

        @Override
        public int sample() {
            double u;
            double x;
            int k;
            do {
                if ((k = (int)((x = this.hIntegralInverse(u = this.hIntegralNumberOfElements + this.rng.nextDouble() * this.r)) + 0.5)) < 1) {
                    k = 1;
                    continue;
                }
                if (k <= this.numberOfElements) continue;
                k = this.numberOfElements;
            } while (!((double)k - x <= this.s) && !(u >= this.hIntegral((double)k + 0.5) - this.h(k)));
            return k;
        }

        public String toString() {
            return "Rejection inversion Zipf deviate [" + this.rng.toString() + "]";
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new RejectionInversionZipfSamplerImpl(rng, this);
        }

        private double hIntegral(double x) {
            double logX = Math.log(x);
            return RejectionInversionZipfSamplerImpl.helper2((1.0 - this.exponent) * logX) * logX;
        }

        private double h(double x) {
            return Math.exp(-this.exponent * Math.log(x));
        }

        private double hIntegralInverse(double x) {
            double t = x * (1.0 - this.exponent);
            if (t < -1.0) {
                t = -1.0;
            }
            return Math.exp(RejectionInversionZipfSamplerImpl.helper1(t) * x);
        }

        private static double helper1(double x) {
            if (Math.abs(x) > 1.0E-8) {
                return Math.log1p(x) / x;
            }
            return 1.0 - x * (0.5 - x * (0.3333333333333333 - 0.25 * x));
        }

        private static double helper2(double x) {
            if (Math.abs(x) > 1.0E-8) {
                return Math.expm1(x) / x;
            }
            return 1.0 + x * 0.5 * (1.0 + x * 0.3333333333333333 * (1.0 + 0.25 * x));
        }
    }
}

