/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import javax.script.ScriptEngineManager;
import org.apache.commons.text.lookup.ScriptStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ScriptStringLookupTest {
    private static final String JS_NAME = "JavaScript";

    ScriptStringLookupTest() {
    }

    @Test
    void testBadEngineName() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ScriptStringLookup.INSTANCE.apply("BAD_ENGINE_NAME:\"Hello World!\""));
    }

    @Test
    void testBadScript() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ScriptStringLookup.INSTANCE.apply("JavaScript:X"));
    }

    @Test
    void testNoScript() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ScriptStringLookup.INSTANCE.apply("ENGINE_NAME:"));
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)ScriptStringLookup.INSTANCE.apply(null));
    }

    @Test
    void testOne() {
        Assertions.assertEquals((Object)"Hello World!", (Object)ScriptStringLookup.INSTANCE.apply("JavaScript:\"Hello World!\""));
    }

    @Test
    void testSanityCheck() {
        Assertions.assertNotNull((Object)new ScriptEngineManager().getEngineByName(JS_NAME), (String)JS_NAME);
    }

    @Test
    void testScriptMissingColon() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ScriptStringLookup.INSTANCE.apply("JavaScript=\"test\""));
    }

    @Test
    void testScriptUsingMultipleColons() {
        Assertions.assertEquals((Object)"It Works", (Object)ScriptStringLookup.INSTANCE.apply("JavaScript:true ? \"It Works\" : \"It Does Not Work\" "));
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)ScriptStringLookup.INSTANCE.toString().isEmpty());
    }
}

